/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.annotations.EcoreIdentityInfo;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.resource.JsonResource;
import org.eclipse.emfcloud.jackson.utils.ValueReader;
import org.eclipse.emfcloud.jackson.utils.ValueWriter;

public class EObjectIdentityProperty
extends EObjectProperty {
    private final ValueReader<Object, String> valueReader;
    private final ValueWriter<EObject, Object> valueWriter;

    public EObjectIdentityProperty(EcoreIdentityInfo info) {
        super(info.getProperty());
        this.valueReader = info.getValueReader();
        this.valueWriter = info.getValueWriter();
    }

    @Override
    public void serialize(EObject bean, JsonGenerator jg, SerializerProvider provider) throws IOException {
        jg.writeObjectField(this.getFieldName(), this.valueWriter.writeValue(bean, provider));
    }

    @Override
    public EObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return null;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, EObject current, DeserializationContext ctxt, Resource resource) throws IOException {
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            jp.nextToken();
        }
        Object value = switch (jp.getCurrentToken()) {
            case JsonToken.VALUE_STRING -> jp.getValueAsString();
            case JsonToken.VALUE_NUMBER_INT -> jp.getValueAsInt();
            case JsonToken.VALUE_NUMBER_FLOAT -> jp.getValueAsLong();
            default -> null;
        };
        if (value != null) {
            String id = this.valueReader.readValue(value, ctxt);
            if (resource instanceof JsonResource && id != null) {
                ((JsonResource)resource).setID(current, id);
            }
        }
    }
}

