/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.Map;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.typechecker.SemanticException;

public class SymTable {
    private SymTable parent;
    private Map<String, SymbolEntry> table;

    public SymTable(SymTable parent) {
        this.parent = parent;
        this.table = Maps.map();
    }

    public void addSymbol(SymbolEntry se, CheckContext ctxt) {
        SymbolEntry other = this.getSymbol(se.getName());
        if (other != null) {
            ctxt.addError(Message.DUPLICATE_DECLARATION, other.getPosition(), se.getName());
            ctxt.addError(Message.DUPLICATE_DECLARATION, se.getPosition(), se.getName());
            throw new SemanticException();
        }
        this.table.put(se.getName(), se);
    }

    public SymbolEntry getSymbol(String name) {
        SymTable st = this;
        do {
            SymbolEntry other;
            if ((other = st.table.get(name)) == null) continue;
            return other;
        } while ((st = st.parent) != null);
        return null;
    }

    public void checkSymbolUsage(CheckContext ctxt) {
        for (SymbolEntry se : this.table.values()) {
            se.checkUsage(ctxt);
        }
    }
}

