/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.preconditions;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifReachabilityRequirementAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToBddExprOnlySupportedExprsCheck
extends CifCheckNoCompDefInst {
    private final Set<PositionObject> alreadyChecked = Sets.set();

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        this.alreadyChecked.clear();
    }

    protected void preprocessAssignment(Assignment asgn, CifCheckViolations violations) {
        this.checkExprOrPred(asgn.getValue(), false, violations);
    }

    protected void preprocessIfUpdate(IfUpdate ifUpdate, CifCheckViolations violations) {
        this.checkPreds((List<Expression>)ifUpdate.getGuards(), false, violations);
    }

    protected void preprocessElifUpdate(ElifUpdate elifUpdate, CifCheckViolations violations) {
        this.checkPreds((List<Expression>)elifUpdate.getGuards(), false, violations);
    }

    protected void preprocessVariableValue(VariableValue values, CifCheckViolations violations) {
        for (Expression value : values.getValues()) {
            this.checkExprOrPred(value, true, violations);
        }
    }

    protected void preprocessEdge(Edge edge, CifCheckViolations violations) {
        this.checkPreds((List<Expression>)edge.getGuards(), false, violations);
    }

    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        this.checkPreds((List<Expression>)comp.getInitials(), true, violations);
        this.checkPreds((List<Expression>)comp.getMarkeds(), false, violations);
        this.checkPreds(CifReachabilityRequirementAnnotationUtils.getPredicates((AnnotatedObject)comp), false, violations);
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        this.checkPreds((List<Expression>)loc.getInitials(), true, violations);
        this.checkPreds((List<Expression>)loc.getMarkeds(), false, violations);
    }

    protected void preprocessInvariant(Invariant inv, CifCheckViolations violations) {
        this.checkPred(inv.getPredicate(), false, violations);
    }

    protected void preprocessEdgeSend(EdgeSend edgeSend, CifCheckViolations violations) {
        Expression value = edgeSend.getValue();
        if (value != null) {
            this.checkExprOrPred(value, false, violations);
        }
    }

    protected void preprocessInternalFunction(InternalFunction func, CifCheckViolations violations) {
        this.checkFunction(func, violations);
    }

    public void checkExprOrPreds(List<Expression> exprs, boolean initial, CifCheckViolations violations) {
        for (Expression expr : exprs) {
            this.checkExprOrPred(expr, initial, violations);
        }
    }

    public void checkExprOrPred(Expression expr, boolean initial, CifCheckViolations violations) {
        CifType type = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (type instanceof BoolType) {
            this.checkPred(expr, initial, violations);
        } else if (type instanceof IntType || type instanceof EnumType) {
            this.checkExpr(expr, initial, violations);
        } else {
            violations.add((PositionObject)expr, "A value of type \"%s\" is used", new Object[]{CifTextUtils.typeToStr((CifType)type)});
        }
    }

    public void checkPreds(List<Expression> preds, boolean initial, CifCheckViolations violations) {
        for (Expression pred : preds) {
            this.checkPred(pred, initial, violations);
        }
    }

    public void checkPred(Expression pred, boolean initial, CifCheckViolations violations) {
        Object valueObj;
        CifType type = CifTypeUtils.normalizeType((CifType)pred.getType());
        Assert.check((boolean)(type instanceof BoolType));
        if (pred instanceof BoolExpression) {
            return;
        }
        if (pred instanceof DiscVariableExpression) {
            return;
        }
        if (pred instanceof InputVariableExpression) {
            return;
        }
        if (pred instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)pred;
            AlgVariable var = algExpr.getVariable();
            if (!this.alreadyChecked.contains(var)) {
                Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)var.getType()) instanceof BoolType));
                Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
                this.checkPred(value, initial, violations);
                this.alreadyChecked.add((PositionObject)var);
            }
            return;
        }
        if (pred instanceof LocationExpression) {
            return;
        }
        if (pred instanceof ConstantExpression) {
            return;
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression unaryExpr = (UnaryExpression)pred;
            UnaryOperator op = unaryExpr.getOperator();
            switch (op) {
                case INVERSE: {
                    this.checkPred(unaryExpr.getChild(), initial, violations);
                    return;
                }
            }
        } else if (pred instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)pred;
            Expression lhs = binaryExpr.getLeft();
            Expression rhs = binaryExpr.getRight();
            BinaryOperator op = binaryExpr.getOperator();
            switch (op) {
                case DISJUNCTION: 
                case CONJUNCTION: {
                    CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                    CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                    if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                        violations.add((PositionObject)pred, "Binary operator \"%s\" is used on values of types \"%s\" and \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                        return;
                    }
                    this.checkPred(lhs, initial, violations);
                    this.checkPred(rhs, initial, violations);
                    return;
                }
                case IMPLICATION: 
                case BI_CONDITIONAL: {
                    this.checkPred(lhs, initial, violations);
                    this.checkPred(rhs, initial, violations);
                    return;
                }
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: {
                    this.checkCmpPred(binaryExpr, initial, violations);
                    return;
                }
            }
        } else {
            FunctionExpression funcRef;
            Function function;
            FunctionCallExpression fcExpr;
            Expression expression;
            if (pred instanceof FunctionCallExpression && (expression = (fcExpr = (FunctionCallExpression)pred).getFunction()) instanceof FunctionExpression && (function = (funcRef = (FunctionExpression)expression).getFunction()) instanceof InternalFunction) {
                InternalFunction internalFunc = (InternalFunction)function;
                for (Expression arg : fcExpr.getArguments()) {
                    this.checkExprOrPred(arg, initial, violations);
                }
                this.checkFunction(internalFunc, violations);
                return;
            }
            if (pred instanceof IfExpression) {
                IfExpression ifExpr = (IfExpression)pred;
                this.checkPreds((List<Expression>)ifExpr.getGuards(), initial, violations);
                this.checkPred(ifExpr.getThen(), initial, violations);
                for (ElifExpression elif : ifExpr.getElifs()) {
                    this.checkPreds((List<Expression>)elif.getGuards(), initial, violations);
                    this.checkPred(elif.getThen(), initial, violations);
                }
                this.checkPred(ifExpr.getElse(), initial, violations);
                return;
            }
            if (pred instanceof SwitchExpression) {
                SwitchExpression switchExpr = (SwitchExpression)pred;
                Expression value = switchExpr.getValue();
                boolean isAutSwitch = CifTypeUtils.isAutRefExpr((Expression)value);
                if (!isAutSwitch) {
                    this.checkExprOrPred(value, initial, violations);
                }
                for (SwitchCase switchCase : switchExpr.getCases()) {
                    if (switchCase.getKey() != null) {
                        this.checkExprOrPred(switchCase.getKey(), initial, violations);
                    }
                    this.checkPred(switchCase.getValue(), initial, violations);
                }
                return;
            }
            if (pred instanceof ReceivedExpression) {
                return;
            }
        }
        Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)pred, (boolean)initial, (boolean)true);
        if (notSingleValue != null) {
            violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
            return;
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)pred, (boolean)initial);
        }
        catch (CifEvalException ex) {
            Expression reportObj = ex.expr != null ? ex.expr : pred;
            violations.add((PositionObject)reportObj, "Failed to statically evaluate a predicate", new Object[0]);
            return;
        }
        Assert.check((boolean)(valueObj instanceof Boolean));
    }

    private void checkCmpPred(BinaryExpression cmpPred, boolean initial, CifCheckViolations violations) {
        Expression lhs = cmpPred.getLeft();
        Expression rhs = cmpPred.getRight();
        CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
        if (ltype instanceof BoolType && rtype instanceof BoolType) {
            this.checkPred(lhs, initial, violations);
            this.checkPred(rhs, initial, violations);
        } else if (ltype instanceof EnumType && rtype instanceof EnumType || ltype instanceof IntType && rtype instanceof IntType) {
            this.checkExpr(lhs, initial, violations);
            this.checkExpr(rhs, initial, violations);
        } else {
            violations.add((PositionObject)cmpPred, "Binary operator \"%s\" is used on values of types \"%s\" and \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)cmpPred.getOperator()), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
        }
    }

    public void checkExpr(Expression expr, boolean initial, CifCheckViolations violations) {
        Object valueObj;
        FunctionExpression funcRef;
        Function function;
        FunctionCallExpression fcExpr;
        Expression expression;
        FunctionCallExpression fcExpr2;
        Expression expression2;
        CifType type = CifTypeUtils.normalizeType((CifType)expr.getType());
        Assert.check((type instanceof IntType || type instanceof EnumType ? 1 : 0) != 0);
        if (expr instanceof DiscVariableExpression) {
            return;
        }
        if (expr instanceof InputVariableExpression) {
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)expr;
            AlgVariable var = algExpr.getVariable();
            if (!this.alreadyChecked.contains(var)) {
                Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
                this.checkExpr(value, initial, violations);
                this.alreadyChecked.add((PositionObject)var);
            }
            return;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unaryExpr = (UnaryExpression)expr;
            UnaryOperator op = unaryExpr.getOperator();
            switch (op) {
                case NEGATE: 
                case PLUS: {
                    this.checkExpr(unaryExpr.getChild(), initial, violations);
                    return;
                }
            }
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)expr;
            Expression lhs = binaryExpr.getLeft();
            Expression rhs = binaryExpr.getRight();
            BinaryOperator op = binaryExpr.getOperator();
            switch (op) {
                case MULTIPLICATION: 
                case SUBTRACTION: 
                case ADDITION: {
                    this.checkExpr(lhs, initial, violations);
                    this.checkExpr(rhs, initial, violations);
                    return;
                }
                case MODULUS: 
                case INTEGER_DIVISION: {
                    Object rhsValueObj;
                    this.checkExpr(lhs, initial, violations);
                    Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)rhs, (boolean)initial, (boolean)true);
                    if (notSingleValue != null) {
                        violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
                        return;
                    }
                    try {
                        rhsValueObj = CifEvalUtils.eval((Expression)rhs, (boolean)initial);
                    }
                    catch (CifEvalException ex) {
                        Expression reportObj = ex.expr != null ? ex.expr : rhs;
                        violations.add((PositionObject)reportObj, "Failed to statically evaluate the divisor for \"%s\"", new Object[]{op});
                        return;
                    }
                    int divisor = (Integer)rhsValueObj;
                    if (divisor == 0) {
                        violations.add((PositionObject)rhs, "Division by zero for \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op)});
                        return;
                    }
                    if (divisor < 0) {
                        violations.add((PositionObject)rhs, "Division by a negative value for \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op)});
                        return;
                    }
                    return;
                }
            }
        }
        if (expr instanceof FunctionCallExpression && (expression2 = (fcExpr2 = (FunctionCallExpression)expr).getFunction()) instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression stdlibRef = (StdLibFunctionExpression)expression2;
            switch (stdlibRef.getFunction()) {
                case ABS: {
                    Expression arg = (Expression)Lists.single((List)fcExpr2.getArguments());
                    this.checkExpr(arg, initial, violations);
                    return;
                }
                case MINIMUM: 
                case MAXIMUM: {
                    for (Expression arg : fcExpr2.getArguments()) {
                        this.checkExpr(arg, initial, violations);
                    }
                    return;
                }
                case SIGN: {
                    Expression arg = (Expression)Lists.single((List)fcExpr2.getArguments());
                    CifType normArgType = CifTypeUtils.normalizeType((CifType)arg.getType());
                    if (!(normArgType instanceof IntType)) break;
                    this.checkExpr(arg, initial, violations);
                    return;
                }
            }
        }
        if (expr instanceof FunctionCallExpression && (expression = (fcExpr = (FunctionCallExpression)expr).getFunction()) instanceof FunctionExpression && (function = (funcRef = (FunctionExpression)expression).getFunction()) instanceof InternalFunction) {
            InternalFunction internalFunc = (InternalFunction)function;
            for (Expression arg : fcExpr.getArguments()) {
                this.checkExprOrPred(arg, initial, violations);
            }
            this.checkFunction(internalFunc, violations);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            this.checkPreds((List<Expression>)ifExpr.getGuards(), initial, violations);
            this.checkExpr(ifExpr.getThen(), initial, violations);
            for (ElifExpression elif : ifExpr.getElifs()) {
                this.checkPreds((List<Expression>)elif.getGuards(), initial, violations);
                this.checkExpr(elif.getThen(), initial, violations);
            }
            this.checkExpr(ifExpr.getElse(), initial, violations);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            boolean isAutSwitch = CifTypeUtils.isAutRefExpr((Expression)value);
            if (!isAutSwitch) {
                this.checkExprOrPred(value, initial, violations);
            }
            for (SwitchCase switchCase : switchExpr.getCases()) {
                if (switchCase.getKey() != null) {
                    this.checkExprOrPred(switchCase.getKey(), initial, violations);
                }
                this.checkExpr(switchCase.getValue(), initial, violations);
            }
            return;
        }
        if (expr instanceof ReceivedExpression) {
            return;
        }
        Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)expr, (boolean)initial, (boolean)true);
        if (notSingleValue != null) {
            violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
            return;
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException ex) {
            Expression reportObj = ex.expr != null ? ex.expr : expr;
            violations.add((PositionObject)reportObj, "Failed to statically evaluate an expression", new Object[0]);
            return;
        }
        Assert.check((valueObj instanceof Integer || valueObj instanceof CifEnumLiteral ? 1 : 0) != 0, (Object)valueObj);
    }

    private void checkFunction(InternalFunction func, CifCheckViolations violations) {
        if (this.alreadyChecked.contains(func)) {
            return;
        }
        this.alreadyChecked.add((PositionObject)func);
        for (DiscVariable localVar : func.getVariables()) {
            if (localVar.getValue() == null) continue;
            Assert.areEqual((Object)localVar.getValue().getValues().size(), (Object)1);
            this.checkExprOrPred((Expression)localVar.getValue().getValues().get(0), false, violations);
        }
        this.checkStatements((List<FunctionStatement>)func.getStatements(), violations);
    }

    private void checkStatements(List<FunctionStatement> statements, CifCheckViolations violations) {
        for (FunctionStatement statement : statements) {
            this.checkStatement(statement, violations);
        }
    }

    private void checkStatement(FunctionStatement statement, CifCheckViolations violations) {
        if (statement instanceof AssignmentFuncStatement) {
            AssignmentFuncStatement assign = (AssignmentFuncStatement)statement;
            this.checkExprOrPred(assign.getValue(), false, violations);
        } else if (statement instanceof IfFuncStatement) {
            IfFuncStatement ifStatement = (IfFuncStatement)statement;
            this.checkPreds((List<Expression>)ifStatement.getGuards(), false, violations);
            this.checkStatements((List<FunctionStatement>)ifStatement.getThens(), violations);
            for (ElifFuncStatement elifStatement : ifStatement.getElifs()) {
                this.checkPreds((List<Expression>)elifStatement.getGuards(), false, violations);
                this.checkStatements((List<FunctionStatement>)elifStatement.getThens(), violations);
            }
            this.checkStatements((List<FunctionStatement>)ifStatement.getElses(), violations);
        } else if (statement instanceof ReturnFuncStatement) {
            ReturnFuncStatement returnStatement = (ReturnFuncStatement)statement;
            this.checkExprOrPreds((List<Expression>)returnStatement.getValues(), false, violations);
        }
    }
}

