/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etphys.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.etphys.eTPhys.ETPhysPackage;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.etphys.eTPhys.ThreadModel;
import org.eclipse.etrice.core.etphys.validation.AbstractETPhysValidator;
import org.eclipse.xtext.validation.Check;

public class ETPhysValidator
extends AbstractETPhysValidator {
    @Check
    public void checkThread(PhysicalThread thread) {
        NodeClass nc = (NodeClass)thread.eContainer();
        if (thread.getPrio() < nc.getPriomin()) {
            this.error("prio less than minimum", (EStructuralFeature)ETPhysPackage.Literals.PHYSICAL_THREAD__PRIO);
        }
        if (thread.getPrio() > nc.getPriomax()) {
            this.error("prio greater than maximum", (EStructuralFeature)ETPhysPackage.Literals.PHYSICAL_THREAD__PRIO);
        }
        if (thread.getExecmode() == ExecMode.BLOCKED) {
            if (thread.getTime() != 0L) {
                this.error("no time interval must be specified with blocked execution mode", (EStructuralFeature)ETPhysPackage.Literals.PHYSICAL_THREAD__TIME);
            }
        } else if (thread.getExecmode() == ExecMode.POLLED) {
            if (thread.getTime() == 0L) {
                this.error("a time interval must be specified with polled execution mode", (EStructuralFeature)ETPhysPackage.Literals.PHYSICAL_THREAD__TIME);
            }
        } else if (thread.getExecmode() == ExecMode.MIXED && thread.getTime() == 0L) {
            this.error("a time interval must be specified with mixed execution mode", (EStructuralFeature)ETPhysPackage.Literals.PHYSICAL_THREAD__TIME);
        }
    }

    @Check
    public void checkNodeClass(NodeClass nc) {
        boolean hasDefault = false;
        for (PhysicalThread thread : nc.getThreads()) {
            if (!thread.isDefault()) continue;
            if (hasDefault) {
                int idx = nc.getThreads().indexOf((Object)thread);
                this.error("only one DefaultThread allowed", (EStructuralFeature)ETPhysPackage.Literals.NODE_CLASS__THREADS, idx);
                continue;
            }
            hasDefault = true;
        }
        if (!hasDefault) {
            this.error("there must be one DefaultThread", (EStructuralFeature)ETPhysPackage.Literals.NODE_CLASS__THREADS);
        }
        if (nc.getRuntime() != null && nc.getRuntime().getThreadModel() == ThreadModel.SINGLE_THREADED && nc.getThreads().size() > 1) {
            this.error("runtime is single threaded but more than one thread defined", (EStructuralFeature)ETPhysPackage.Literals.NODE_CLASS__THREADS);
        }
    }
}

