/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CExtensions
implements ILanguageExtension {
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String string = null;
        string = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return string;
    }

    public String accessLevelPrivate() {
        return "static ";
    }

    public String accessLevelProtected() {
        return "static ";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "self->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        String string = null;
        string = hasArgs ? "* self, " : "* self";
        return classname + string;
    }

    public String selfPointer(boolean hasArgs) {
        String string = null;
        string = hasArgs ? "self, " : "self";
        return string;
    }

    public String scopeSeparator() {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return classname + "_";
    }

    public String memberInDeclaration(String namespace, String member) {
        return namespace + "_" + member;
    }

    public String memberInUse(String namespace, String member) {
        return namespace + "_" + member;
    }

    public String getCHeaderFileName(RoomClass rc) {
        String string = rc.getName();
        String string2 = this.headerExtension();
        return string + string2;
    }

    public String getCSourceFileName(RoomClass rc) {
        String string = rc.getName();
        String string2 = this.sourceExtension();
        return string + string2;
    }

    public String getCUtilsFileName(RoomClass rc) {
        String string = rc.getName();
        String string2 = string + "_Utils";
        String string3 = this.headerExtension();
        return string2 + string3;
    }

    public String getInstSourceFileName(RoomClass rc) {
        String string = rc.getName();
        String string2 = string + "_Inst";
        String string3 = this.headerExtension();
        return string2 + string3;
    }

    public String getDispSourceFileName(RoomClass rc) {
        String string = rc.getName();
        String string2 = string + "_Disp";
        String string3 = this.headerExtension();
        return string2 + string3;
    }

    public String getCHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = this.headerExtension();
        return string4 + string5;
    }

    public String getCSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = this.sourceExtension();
        return string4 + string5;
    }

    public String getInstSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = string4 + "_Inst";
        String string6 = this.headerExtension();
        return string5 + string6;
    }

    public String getDispSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = string4 + "_Disp";
        String string6 = this.headerExtension();
        return string5 + string6;
    }

    public String getAddressMapFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = string4 + "_AddressMap";
        return string5 + ".json";
    }

    public String getResourceMapFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = string + "_";
        String string3 = ssi.getName();
        String string4 = string2 + string3;
        String string5 = string4 + "_ResourceMap";
        return string5 + ".json";
    }

    public String headerExtension() {
        String string = null;
        boolean bl = this._generatorOptionsHelper.isCppFileExtensions(Main.getSettings());
        string = bl ? ".hpp" : ".h";
        return string;
    }

    public String sourceExtension() {
        String string = null;
        boolean bl = this._generatorOptionsHelper.isCppFileExtensions(Main.getSettings());
        string = bl ? ".cpp" : ".c";
        return string;
    }

    public CharSequence getIncludeGuardString(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_");
        String string = filename.toUpperCase();
        stringConcatenation.append(string);
        stringConcatenation.append("_H_");
        return stringConcatenation;
    }

    public CharSequence generateIncludeGuardBegin(RoomClass rc) {
        CharSequence charSequence = null;
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = string + "_";
        String string3 = rc.getName();
        String filename = string2 + string3;
        charSequence = this.generateIncludeGuardBegin(filename);
        return charSequence;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass rc) {
        CharSequence charSequence = null;
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = string + "_";
        String string3 = rc.getName();
        String filename = string2 + string3;
        charSequence = this.generateIncludeGuardEnd(filename);
        return charSequence;
    }

    public CharSequence generateIncludeGuardBegin(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#ifndef ");
        CharSequence charSequence = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#define ");
        CharSequence charSequence2 = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence generateIncludeGuardEnd(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#endif /* ");
        CharSequence charSequence = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append(" */");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence generateCppExternCBegin() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#ifdef __cplusplus");
        stringConcatenation.newLine();
        stringConcatenation.append("extern \ufffdC\ufffd {");
        stringConcatenation.newLine();
        stringConcatenation.append("#endif // __cplusplus");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public CharSequence generateCppExternCEnd() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#ifdef __cplusplus");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("#endif // __cplusplus");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public boolean usesInheritance() {
        return false;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String string = null;
        boolean bl = entries.isEmpty();
        if (bl) {
            return "/* empty enum not generated */";
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("enum ");
        stringConcatenation.append(name);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        boolean bl2 = false;
        for (Pair<String, String> entry : entries) {
            if (!bl2) {
                bl2 = true;
            } else {
                stringConcatenation.appendImmediate((Object)",", "\t");
            }
            stringConcatenation.append("\t");
            String string2 = (String)entry.getFirst();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append(" = ");
            String string3 = (String)entry.getSecond();
            stringConcatenation.append(string3, "\t");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        string = stringConcatenation.toString();
        return string;
    }

    public String booleanConstant(boolean b) {
        String string = null;
        string = b ? "ET_TRUE" : "ET_FALSE";
        return string;
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "NULL";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(type);
        if (isRef) {
            stringConcatenation.append("*");
        }
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(type);
        if (isRef) {
            stringConcatenation.append("*");
        }
        stringConcatenation.append(" ");
        stringConcatenation.append(name);
        stringConcatenation.append("[");
        stringConcatenation.append((Object)size);
        stringConcatenation.append("]");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation.toString();
    }

    public String superCall(String baseClassName, String method, String args) {
        return "";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        Object object;
        boolean bl;
        Object object2 = null;
        String string = type.getTargetName();
        boolean bl2 = false;
        if (type.getTargetName().equals("char") && value.length() == 1) {
            bl2 = true;
            object2 = "'" + value + "'";
        }
        if (!bl2 && (bl = Objects.equals(object = type.getType(), LiteralType.CHAR))) {
            bl2 = true;
            object2 = "\"" + value + "\"";
        }
        if (!bl2 && (value.contains(",") || value.contains("{"))) {
            bl2 = true;
            object = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl3 = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl3) {
                    bl3 = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string2 = this.toValueLiteral(type, v.trim());
                stringConcatenation.append(string2);
                ++n2;
            }
            stringConcatenation.append(" }");
            object = stringConcatenation.toString();
            object2 = object;
        }
        if (!bl2 && Objects.equals(string, "boolean")) {
            bl2 = true;
            object = null;
            bl = value.equals("true");
            object = bl ? "ET_TRUE" : "ET_FALSE";
            object2 = object;
        }
        if (!bl2) {
            object2 = value;
        }
        return object2;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String string = null;
        if (value.contains(",") || value.contains("{")) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.convertStringEnumLiteral(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.convertStringEnumLiteral(type, value);
        }
        return string;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean bl = v.startsWith(type.getName());
        if (bl) {
            int n = type.getName().length();
            int n2 = n + 1;
            v = v.substring(n2);
        }
        EList eList = type.getLiterals();
        for (EnumLiteral l : eList) {
            boolean bl2 = l.getName().equals(v);
            if (!bl2) continue;
            String string = type.getName();
            String string2 = string + "_";
            String string3 = l.getName();
            return string2 + string3;
        }
        return null;
    }

    public String defaultValue(DataType dt) {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        String string = null;
        boolean bl2 = false;
        if (dt instanceof PrimitiveType) {
            bl2 = true;
            string = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!bl2 && dt instanceof EnumerationType) {
            bl2 = true;
            string = this.getDefaultValue((EnumerationType)dt);
        }
        if (!bl2 && dt instanceof ExternalType) {
            bl2 = true;
            object4 = null;
            object3 = ((ExternalType)dt).getDefaultValueLiteral();
            boolean bl3 = bl = object3 != null;
            if (bl) {
                return ((ExternalType)dt).getDefaultValueLiteral();
            }
            String string2 = ((ExternalType)dt).getName();
            object2 = "external type " + string2;
            object = (String)object2 + "has no default initialization";
            this.diagnostician.error((String)object, ((ExternalType)dt).eContainer(), ((ExternalType)dt).eContainingFeature());
            object4 = "";
            string = object4;
        }
        if (!bl2 && dt instanceof DataClass) {
            bl2 = true;
            object4 = new StringConcatenation();
            object4.append("{");
            object4.newLine();
            object3 = this._roomHelpers.getAllAttributes((DataClass)dt);
            bl = false;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Attribute att = (Attribute)object2.next();
                if (!bl) {
                    bl = true;
                } else {
                    object4.appendImmediate((Object)",", "\t");
                }
                object4.append("\t");
                object = this.initializationWithDefaultValues(att);
                object4.append((String)object, "\t");
                object4.newLineIfNotEmpty();
            }
            object4.append("}");
            object4.newLine();
            string = object4.toString();
        }
        return string;
    }

    public String getDefaultValue(EnumerationType type) {
        String string = null;
        boolean bl = type.getLiterals().isEmpty();
        string = bl ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return string;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String string = null;
        String dv = this.defaultValue(dt);
        string = this.initializer(dv, size);
        return string;
    }

    private String initializer(String dv, int size) {
        Object object = null;
        if (size > 1) {
            String string = null;
            Object res = "{";
            int i = 0;
            while (i < size) {
                res = (String)res + dv;
                if (++i >= size) continue;
                res = (String)res + ",";
            }
            string = (String)res + "}";
            object = string;
        } else {
            object = dv;
        }
        return object;
    }

    public String initializationWithDefaultValues(Attribute att) {
        String string = null;
        String dv = att.getDefaultValueLiteral();
        String string2 = null;
        if (dv != null) {
            String string3 = null;
            boolean bl = dv.startsWith("{");
            string3 = bl ? dv : this.initializer(dv, att.getSize());
            string2 = string3;
        } else {
            String string4 = null;
            boolean bl = att.getType().isRef();
            string4 = bl ? this.initializer("NULL", att.getSize()) : this.initializationWithDefaultValues(att.getType().getType(), att.getSize());
            string2 = string4;
        }
        string = string2;
        return string;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        boolean isPrim;
        DataType dataType;
        Object object;
        Object object2;
        DataType dataType2;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        if (data == null) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        String string = null;
        DataType dataType3 = data.getRefType().getType();
        if (dataType3 instanceof PrimitiveType) {
            var5_5 = data.getRefType().getType();
            string = ((PrimitiveType)var5_5).getTargetName();
        } else {
            var5_5 = null;
            dataType2 = data.getRefType().getType();
            if (dataType2 instanceof EnumerationType) {
                object2 = data.getRefType().getType();
                var5_5 = this.getTargetType((EnumerationType)object2);
            } else {
                object2 = null;
                object = data.getRefType().getType();
                if (object instanceof ExternalType) {
                    dataType = data.getRefType().getType();
                    object2 = ((ExternalType)dataType).getTargetName();
                } else {
                    object2 = data.getRefType().getType().getName();
                }
                var5_5 = object2;
            }
            string = var5_5;
        }
        Object typeName = string;
        dataType2 = null;
        object2 = data.getRefType().getType();
        if (object2 instanceof PrimitiveType) {
            object = null;
            dataType = data.getRefType().getType();
            ct = ((PrimitiveType)dataType).getCastName();
            Object object3 = null;
            object3 = ct != null && !ct.isEmpty() ? ct : typeName;
            dataType2 = object = object3;
        } else {
            object = null;
            dataType = data.getRefType().getType();
            if (dataType instanceof EnumerationType) {
                ct = data.getRefType().getType();
                object = this.getCastType((EnumerationType)ct);
            } else {
                object = typeName;
            }
            dataType2 = object;
        }
        Object castTypeName = dataType2;
        castTypeName = (String)castTypeName + "*";
        String deRef = "*";
        boolean isRef = data.getRefType().isRef();
        boolean bl = isPrim = data.getRefType().getType() instanceof PrimitiveType || data.getRefType().getType() instanceof EnumerationType;
        if (isRef) {
            typeName = (String)typeName + "*";
            castTypeName = (String)castTypeName + "*";
        } else if (!isPrim) {
            typeName = (String)typeName + "*";
            deRef = "";
        }
        String string2 = null;
        string2 = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        String dataName = string2;
        String dataArg = ", " + dataName;
        String typedData = (String)typeName + " " + dataName + " = " + deRef + "((" + (String)castTypeName + ") generic_data__et);\nET_TOUCH(" + dataName + ");\n";
        String typedArgList = ", " + (String)typeName + " " + dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getIncludePath(RoomClass rc) {
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "/");
        String string2 = "\"" + string;
        String string3 = string2 + "/";
        String string4 = this.getCHeaderFileName(rc);
        String string5 = string3 + string4;
        return string5 + "\"";
    }

    public String getUtilsIncludePath(RoomClass rc) {
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "/");
        String string2 = "\"" + string;
        String string3 = string2 + "/";
        String string4 = this.getCUtilsFileName(rc);
        String string5 = string3 + string4;
        return string5 + "\"";
    }

    public String getTargetType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getTargetName() : type.getName();
        return string;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean bl;
        String string = null;
        EObject eObject = literal.eContainer();
        EnumerationType type = (EnumerationType)eObject;
        String cast = this.getTargetType(type);
        Object object = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl2 = bl = primitiveType == null;
        if (bl) {
            object = Long.toString(literal.getLiteralValue());
        } else {
            String string2 = Long.toString(literal.getLiteralValue());
            String string3 = "((" + cast + ")" + string2;
            object = string3 + ")";
        }
        string = object;
        return string;
    }

    public String getCastType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getCastName() : type.getName();
        return string;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean bl;
        Object object = null;
        RefableType it = type;
        boolean bl2 = false;
        if (Objects.equals(it, null)) {
            bl2 = true;
            object = "void";
        }
        if (!bl2 && (bl = it.isRef())) {
            bl2 = true;
            String string = this.getDataTypeName(type.getType());
            String string2 = this.pointerLiteral();
            object = string + string2;
        }
        if (!bl2) {
            object = this.getDataTypeName(type.getType());
        }
        return object;
    }

    public String getDataTypeName(DataType it) {
        String string = null;
        boolean bl = false;
        if (it instanceof PrimitiveType) {
            bl = true;
            string = ((PrimitiveType)it).getTargetName();
        }
        if (!bl && it instanceof EnumerationType) {
            bl = true;
            string = this.getTargetType((EnumerationType)it);
        }
        if (!bl && it instanceof ExternalType) {
            bl = true;
            string = ((ExternalType)it).getTargetName();
        }
        if (!bl) {
            string = it.getName();
        }
        return string;
    }

    public String toParameterDecl(VarDecl it) {
        Object object = null;
        boolean bl = false;
        boolean bl2 = it.isVarargs();
        if (bl2) {
            bl = true;
            object = "...";
        }
        if (!bl) {
            String string = this.getTypeSignature(it.getRefType());
            String string2 = string + " ";
            String string3 = it.getName();
            object = string2 + string3;
        }
        return object;
    }
}

