/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;

public abstract class CallHierarchyNode
implements ICallHierarchyNode {
    private static final ICallHierarchyNode[] NO_CHILDREN = new ICallHierarchyNode[0];
    private static final ICallLocation[] NO_CALL_LOCATIONS = new ICallLocation[0];
    private final ICallHierarchyNode parent;
    private final Object element;
    private final boolean recursive;
    private final List<ICallLocation> callLocations = new ArrayList<ICallLocation>();

    protected CallHierarchyNode(ICallHierarchyNode parent, Object element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.element = element;
        this.recursive = ICallHierarchyNode.super.isRecursive();
    }

    @Override
    public final Object getElement() {
        return this.element;
    }

    @Override
    public final ICallHierarchyNode getParent() {
        return this.parent;
    }

    @Override
    public final ICallLocation[] getCallLocations() {
        return this.callLocations.toArray(NO_CALL_LOCATIONS);
    }

    public void addCallLocation(ICallLocation callLocation) {
        if (callLocation == null) {
            throw new IllegalArgumentException();
        }
        this.callLocations.add(callLocation);
    }

    @Override
    public final boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public final ICallHierarchyNode[] getChildren(IProgressMonitor monitor) {
        if (!this.mayHaveChildren()) {
            return NO_CHILDREN;
        }
        return this.computeChildren(monitor);
    }

    protected abstract ICallHierarchyNode[] computeChildren(IProgressMonitor var1);
}

