/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateful.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTest;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTestLocal;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Local;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;

@Stateful(name="SecTestEJB")
@Remote(value={SecTest.class})
@Local(value={SecTestLocal.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class SecTestEJB
implements SecTest {
    private SessionContext sctx = null;

    @Override
    @RolesAllowed(value={"Manager", "VP"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbNotAuthz() {
        return true;
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbIsAuthz() {
        return true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbSecRoleRef(String role) {
        return this.sctx.isCallerInRole(role);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbOverloadedSecRoleRefs(String role1) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ") = " + this.sctx.isCallerInRole(role1)));
        return this.sctx.isCallerInRole(role1);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ")= " + this.sctx.isCallerInRole(role1) + "isCallerInRole(" + role2 + ")= " + this.sctx.isCallerInRole(role2)));
        return this.sctx.isCallerInRole(role1) && this.sctx.isCallerInRole(role2);
    }

    @Override
    @Remove
    public boolean checktest1() {
        return true;
    }

    @Override
    @DenyAll
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean excludetest1() {
        return true;
    }

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
    }
}

