/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.entity;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.entity.NameOnlyInXML;
import ee.jakarta.tck.persistence.core.override.entity.NoEntityAnnotation;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 9L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception:test failed ", e);
        }
    }

    public void testNameOnlyInXML() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            NameOnlyInXML entity = new NameOnlyInXML();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAll").getResultList();
                this.logTrace("Result of the entity is " + result.size());
                if (result.size() == 1) {
                    this.logTrace("Test Passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNameOnlyInXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testNameOnlyInAnnotation() throws Exception {
        List result = this.getEntityManager().createQuery("SELECT m FROM NAMEONLYINANNOTATION m").getResultList();
        if (result.size() != 0) {
            throw new Exception("Expected the size to be 0  but it is -" + result.size());
        }
        this.logTrace("Test Passed");
    }

    public void testNameOverride() throws Exception {
        List result = this.getEntityManager().createQuery("SELECT n FROM NAMEOVERRIDE n").getResultList();
        if (result.size() != 0) {
            throw new Exception("Expected the size to be 0  but it is -" + result.size());
        }
        this.logTrace("Test Passed");
    }

    public void testNoEntityAnnotation() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            NoEntityAnnotation entity = new NoEntityAnnotation();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAllNoEntityAnnotation").getResultList();
                this.logTrace("Result of the entity is " + result.size());
                if (result.size() == 1) {
                    this.logTrace("Test Passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoEntityAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NAMEONLYINXML").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYANNOTATION").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

