/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.cdi;

import ee.jakarta.tck.persistence.ee.cdi.CtsEm2Qualifier;
import ee.jakarta.tck.persistence.ee.cdi.CtsEmQualifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

@RequestScoped
public class TestBeanEM {
    Logger logger = Logger.getLogger(TestBeanEM.class.getName());
    @Inject
    @CtsEmQualifier
    private EntityManager entityManager1;
    @Inject
    @CtsEm2Qualifier
    private EntityManager entityManager2;
    @Inject
    @CtsEmQualifier
    private EntityManagerFactory entityManagerFactory1;
    @Inject
    @CtsEm2Qualifier
    private EntityManagerFactory entityManagerFactory2;

    public void logMsg(String msg) {
        this.logger.info(msg);
    }

    public void logTrace(String msg) {
        this.logger.fine(msg);
    }

    public void logErr(String msg) {
        this.logger.severe(msg);
    }

    public void logErr(String msg, Throwable e) {
        this.logger.log(Level.SEVERE, msg, e);
    }

    public void injectEntityManagerUsingQualifier() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.entityManager1 != null) {
                this.logTrace("Received non-null EntityManager");
                pass1 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEm2Qualifier");
            if (this.entityManager2 != null) {
                this.logTrace("Received non-null EntityManager");
                pass2 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("injectEntityManagerUsingQualifier failed");
        }
        this.logMsg("Test PASSED");
    }

    public void injectEntityManagerFactoryUsingQualifier() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Test @CtsEmQualifier");
            if (this.entityManagerFactory1 != null) {
                this.logTrace("Received non-null EntityManagerFactory1");
                pass1 = true;
            } else {
                this.logErr("Received null EntityManagerFactory1");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test @CtsEm2Qualifier");
            if (this.entityManagerFactory2 != null) {
                this.logTrace("Received non-null EntityManagerFactory2");
                pass2 = true;
            } else {
                this.logErr("Received null EntityManagerFactory2");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("injectEntityManagerFactoryUsingQualifier failed");
        }
        this.logMsg("Test PASSED");
    }
}

