/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.container.asyncresponse;

import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.AsyncResponseBlockingQueue;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.TckTimeoutHandler;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@Path(value="resource")
public class Resource {
    public static final String RESUMED = "Response resumed";
    public static final String ISE = "Illegal State Exception Thrown";
    public static final String NOE = "No Exception Thrown";
    public static final String FALSE = "A method returned false";
    public static final String TRUE = "A method return true";
    private static final AsyncResponseBlockingQueue[] stage = new AsyncResponseBlockingQueue[]{new AsyncResponseBlockingQueue(1), new AsyncResponseBlockingQueue(1), new AsyncResponseBlockingQueue(1)};

    @GET
    @Path(value="suspend")
    public void suspend(@Suspended AsyncResponse asyncResponse) {
        stage[0].add(asyncResponse);
    }

    @GET
    @Path(value="clear")
    public void clear() {
        for (AsyncResponseBlockingQueue element : stage) {
            element.clear();
        }
    }

    @GET
    @Path(value="cancelvoid")
    public String cancel(@QueryParam(value="stage") String stage) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        boolean ret = response.cancel();
        Resource.addResponse(response, stage);
        return (ret &= response.cancel()) ? TRUE : FALSE;
    }

    @POST
    @Path(value="cancelretry")
    public String cancelretry(@QueryParam(value="stage") String stage, String sRetryAfter) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        int retryAfter = Integer.parseInt(sRetryAfter);
        boolean b = response.cancel(retryAfter);
        Resource.addResponse(response, stage);
        return (b &= response.cancel(retryAfter * 2)) ? TRUE : FALSE;
    }

    @POST
    @Path(value="canceldate")
    public String cancelDate(@QueryParam(value="stage") String stage, String sRetryAfter) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        long retryAfter = Long.parseLong(sRetryAfter);
        boolean b = response.cancel(new Date(retryAfter));
        Resource.addResponse(response, stage);
        return (b &= response.cancel(new Date(retryAfter + 20000L))) ? TRUE : FALSE;
    }

    @GET
    @Path(value="iscanceled")
    public String isCanceled(@QueryParam(value="stage") String stage) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        boolean is = response.isCancelled();
        Resource.addResponse(response, stage);
        return is ? TRUE : FALSE;
    }

    @GET
    @Path(value="isdone")
    public String isDone(@QueryParam(value="stage") String stage) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        boolean is = response.isDone();
        Resource.addResponse(response, stage);
        return is ? TRUE : FALSE;
    }

    @GET
    @Path(value="issuspended")
    public String isSuspended(@QueryParam(value="stage") String stage) {
        AsyncResponse response = Resource.takeAsyncResponse(stage);
        boolean is = response.isSuspended();
        Resource.addResponse(response, stage);
        return is ? TRUE : FALSE;
    }

    @POST
    @Path(value="resume")
    public String resume(@QueryParam(value="stage") String stage, String response) {
        AsyncResponse async = Resource.takeAsyncResponse(stage);
        boolean b = Resource.resume(async, response);
        Resource.addResponse(async, stage);
        return b ? TRUE : FALSE;
    }

    @GET
    @Path(value="resumechecked")
    public String resumeWithCheckedException(@QueryParam(value="stage") String stage) {
        AsyncResponse async = Resource.takeAsyncResponse(stage);
        boolean b = async.resume((Throwable)new IOException(RESUMED));
        Resource.addResponse(async, stage);
        return b ? TRUE : FALSE;
    }

    @GET
    @Path(value="resumeruntime")
    public String resumeWithRuntimeException(@QueryParam(value="stage") String stage) {
        AsyncResponse async = Resource.takeAsyncResponse(stage);
        boolean b = async.resume((Throwable)new RuntimeException(RESUMED));
        Resource.addResponse(async, stage);
        return b ? TRUE : FALSE;
    }

    @POST
    @Path(value="settimeout")
    public void setTimeOut(@QueryParam(value="stage") String stage, String milis) {
        AsyncResponse async = Resource.takeAsyncResponse(stage);
        async.setTimeout(Long.parseLong(milis), TimeUnit.MILLISECONDS);
        Resource.addResponse(async, stage);
    }

    @POST
    @Path(value="timeouthandler")
    public void setTimeoutHandler(@QueryParam(value="stage") String stage, int handlerValue) {
        TckTimeoutHandler handler = new TckTimeoutHandler(handlerValue);
        AsyncResponse async = Resource.takeAsyncResponse(stage);
        async.setTimeoutHandler((TimeoutHandler)handler);
        async.setTimeout(200L, TimeUnit.MILLISECONDS);
        Resource.addResponse(async, stage);
    }

    protected static AsyncResponse takeAsyncResponse(String stageId) {
        return Resource.takeAsyncResponse(Integer.parseInt(stageId));
    }

    protected static AsyncResponse takeAsyncResponse(int stageId) {
        Response.ResponseBuilder error = Resource.createErrorResponseBuilder();
        AsyncResponse asyncResponse = null;
        try {
            asyncResponse = (AsyncResponse)stage[stageId].take();
        }
        catch (InterruptedException e) {
            throw new WebApplicationException(error.entity((Object)"ArrayBlockingQueue#take").build());
        }
        return asyncResponse;
    }

    protected static final void addResponse(AsyncResponse response, String stageId) {
        int id = Integer.parseInt(stageId) + 1;
        if (id != stage.length) {
            stage[id].add(response);
        }
    }

    protected static boolean resume(AsyncResponse takenResponse, Object response) {
        return takenResponse.resume(response);
    }

    protected static Response.ResponseBuilder createErrorResponseBuilder() {
        return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED);
    }
}

