/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.resourceDefs.servlet;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.annotation.security.DeclareRoles;
import jakarta.resource.AdministeredObjectDefinition;
import jakarta.resource.AdministeredObjectDefinitions;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@DeclareRoles(value={"Administrator", "Manager", "Employee"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"Administrator"}), httpMethodConstraints={@HttpMethodConstraint(value="GET", rolesAllowed={"Administrator"}), @HttpMethodConstraint(value="POST", rolesAllowed={"Administrator"})})
@WebServlet(name="AODTestServlet", urlPatterns={"/AODTestServlet"})
@AdministeredObjectDefinitions(value={@AdministeredObjectDefinition(name="java:app/env/CTSAdminObjectForAppScope", description="application scoped AdminObjectDefinition", interfaceName="jakarta.jms.Queue", className="com.sun.ts.tests.common.connector.embedded.adapter1.CRDAdminObject", resourceAdapter="#whitebox-rd"), @AdministeredObjectDefinition(name="java:comp/env/CTSAdminObjectForCompScope", description="component scoped AdminObjectDefinition", interfaceName="jakarta.jms.Queue", className="com.sun.ts.tests.common.connector.embedded.adapter1.CRDAdminObject", resourceAdapter="#whitebox-rd"), @AdministeredObjectDefinition(name="java:module/env/CTSAdminObjectForModuleScope", description="module scoped AdminObjectDefinition", interfaceName="jakarta.jms.Queue", className="com.sun.ts.tests.common.connector.embedded.adapter1.CRDAdminObject", resourceAdapter="#whitebox-rd"), @AdministeredObjectDefinition(name="java:global/env/CTSAdminObjectForGlobalScope", description="globally scoped AdminObjectDefinition", interfaceName="jakarta.jms.Queue", className="com.sun.ts.tests.common.connector.embedded.adapter1.CRDAdminObject", resourceAdapter="#whitebox-rd")})
public class AODTestServlet
extends HttpServlet {
    private String servletAppContext = null;
    private String testMethod = null;
    private String RARJndiScope = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in AODTestServlet.doGet()");
        this.getPropsAndParams(request, response);
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in AODTestServlet.doPost()");
        this.getPropsAndParams(request, response);
        this.doTests(request, response);
    }

    private void doTests(HttpServletRequest request, HttpServletResponse response) {
        this.debug("in AODTestServlet.doTests()");
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (Exception ex) {
            this.debug("got exception in AODTestServlet");
            ex.printStackTrace();
        }
        this.getPropsAndParams(request, response);
        if (this.testMethod.equals("ValidateGlobalAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateGlobalAdminObj");
            this.validateGlobalAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateAppAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateAppAdminObj");
            this.validateAppAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateCompAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateCompAdminObj");
            this.validateCompAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateModuleAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateModuleAdminObj");
            this.validateModuleAdminObj(request, response);
        }
    }

    private void getPropsAndParams(HttpServletRequest req, HttpServletResponse response) {
        this.testMethod = req.getParameter("method.under.test");
        this.RARJndiScope = req.getParameter("rar.jndi.scope");
        this.debug("AODTestServlet.getPropsAndParams():  testMethod = " + this.testMethod);
        this.debug("AODTestServlet.getPropsAndParams():  RARJndiScope = " + this.RARJndiScope);
    }

    public void validateGlobalAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "ValidateGlobalAdminObj() passed.");
            } else {
                this.send_output(out, "validateConnectorResource() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->ValidateGlobalAdminObj() failed");
            ex.printStackTrace();
        }
    }

    public void validateAppAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "ValidateAppAdminObj() passed.");
            } else {
                this.send_output(out, "validateAppAdminObj() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->ValidateAppAdminObj() failed");
            ex.printStackTrace();
        }
    }

    public void validateCompAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "ValidateCompAdminObj() passed.");
            } else {
                this.send_output(out, "validateCompAdminObj() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->ValidateCompAdminObj() failed");
            ex.printStackTrace();
        }
    }

    public void validateModuleAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "ValidateModuleAdminObj() passed.");
            } else {
                this.send_output(out, "validateModuleAdminObj() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->ValidateModuleAdminObj() failed");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnectorResource(String jndiName, boolean expectSuccess) {
        Object c = null;
        boolean rval = false;
        try {
            this.debug("validateConnectorResource():  calling new TSNamingContext()");
            TSNamingContext ic = new TSNamingContext();
            this.debug("Doing lookup of jndiName = " + jndiName);
            Object ds = ic.lookup(jndiName);
            this.debug("validateConnectorResource(): Successfully did lookup of jndiName = " + jndiName);
            rval = true;
        }
        catch (Exception e) {
            this.debug("Fail to access connector resource: " + jndiName);
            e.printStackTrace();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception exception) {}
        }
        return rval;
    }

    public void send_output(PrintWriter out, String str) {
        if (out != null) {
            out.println(str);
            out.flush();
            this.debug(str);
        } else {
            this.print_err("ERROR, Null PrintWriter:  can not properly send back message: " + str);
        }
    }

    public void print_err(String str) {
        System.err.println(str);
        this.debug(str);
    }

    public void debug(String str) {
        TestUtil.logMsg((String)str);
        System.out.println(str);
    }
}

