/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.ui.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.polarsys.kitalpha.pdt.introspector.preferences.utils.IntrospectorPreferenceUtils;
import org.polarsys.kitalpha.pdt.introspector.ui.dialog.ResourceReuseSettingsDialog;
import org.polarsys.kitalpha.pdt.introspector.ui.preferences.EclipseIntrospectionPreferencePageMessages;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class IntrospectionWizardFirstPage
extends WizardPage {
    private Text specifyText;
    private Button checkSpecifyingNameButton;
    private Button perimeterPlatformOnlyButton;
    private Button workspaceOnlyButton;
    private Button bothButton;
    private Button filterButton;
    private Text filterText;
    private Button incremantalIntrospectionButton;
    private Button sameFolderButton;
    private Button sameWorkspaceButton;
    private Button modelReuseButton;
    private Button settingsButton;
    private Button createPackageButton;
    private Button storeIssuesButton;
    private Button ignoreQualifierButton;
    private Button overridePreferencesButton;
    private SearchCriteria criteria;

    public IntrospectionWizardFirstPage(IFolder selection) {
        this(selection.getName());
    }

    protected IntrospectionWizardFirstPage(String pageName) {
        super(pageName);
        this.setTitle(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionWizardPage_Tittle);
        this.setDescription(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionWizardPage_Summary);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout compositeLayout = new GridLayout();
        container.setLayout((Layout)compositeLayout);
        this.createGeneralSettingsGroup(container);
        this.createPerimeterGroup(container);
        this.createIncrementalGroup(container);
        this.createAdvancedSettingsGroup(container);
        this.setControl((Control)container);
    }

    private void createGeneralSettingsGroup(Composite container) {
        Group generalSettingGroup = new Group(container, 4);
        generalSettingGroup.setLayoutData((Object)new GridData(1808));
        generalSettingGroup.setText("General settings");
        GridLayout generalSettingsLayout = new GridLayout();
        generalSettingsLayout.numColumns = 2;
        generalSettingsLayout.marginHeight = 5;
        generalSettingsLayout.marginWidth = 5;
        generalSettingGroup.setLayout((Layout)generalSettingsLayout);
        this.checkSpecifyingNameButton = new Button((Composite)generalSettingGroup, 32);
        this.checkSpecifyingNameButton.setText("Specify generated model name");
        this.checkSpecifyingNameButton.setSelection(false);
        this.checkSpecifyingNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IntrospectionWizardFirstPage.this.specifyText.setEnabled(IntrospectionWizardFirstPage.this.checkSpecifyingNameButton.getSelection());
            }
        });
        this.specifyText = new Text((Composite)generalSettingGroup, 2048);
        this.specifyText.setLayoutData((Object)new GridData(768));
        this.specifyText.setText("Eclipse Model");
        this.specifyText.setEnabled(false);
    }

    public String getModelName() {
        return this.specifyText.getText();
    }

    public boolean modelNameHaveBeenSetted() {
        return this.checkSpecifyingNameButton.getSelection();
    }

    private void createAdvancedSettingsGroup(Composite container) {
        Group advancedSettingsGroup = new Group(container, 4);
        advancedSettingsGroup.setText("Advanced settings");
        advancedSettingsGroup.setLayoutData((Object)new GridData(1808));
        GridLayout specLayout = new GridLayout();
        specLayout.numColumns = 1;
        advancedSettingsGroup.setLayout((Layout)specLayout);
        this.createPackageButton = new Button((Composite)advancedSettingsGroup, 32);
        this.createPackageButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_CreatePackagesLabel);
        this.createPackageButton.setSelection(IntrospectorPreferenceUtils.getCreatePackageSetting());
        this.storeIssuesButton = new Button((Composite)advancedSettingsGroup, 32);
        this.storeIssuesButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_StoreIntrospectionIssuesLabel);
        this.storeIssuesButton.setSelection(IntrospectorPreferenceUtils.getStoreIntrospectionIssue());
        this.ignoreQualifierButton = new Button((Composite)advancedSettingsGroup, 32);
        this.ignoreQualifierButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_QualifierMatchLabel);
        this.ignoreQualifierButton.setSelection(IntrospectorPreferenceUtils.getQualifierMatch());
        this.overridePreferencesButton = new Button((Composite)advancedSettingsGroup, 32);
        this.overridePreferencesButton.setText("Override introspector preferences according to this settings");
    }

    public boolean preferencesHaveBeenOverriden() {
        return this.overridePreferencesButton.getSelection();
    }

    private void createIncrementalGroup(Composite container) {
        Group incrementalGroup = new Group(container, 4);
        incrementalGroup.setText("Incremental Introspection");
        incrementalGroup.setLayoutData((Object)new GridData(1808));
        GridLayout specLayout = new GridLayout();
        specLayout.numColumns = 1;
        incrementalGroup.setLayout((Layout)specLayout);
        this.incremantalIntrospectionButton = new Button((Composite)incrementalGroup, 32);
        this.incremantalIntrospectionButton.setText("Activate incremental introspection");
        this.incremantalIntrospectionButton.setSelection(IntrospectorPreferenceUtils.getActivateIncrementalIntrospection());
        Label incrementalLabel = new Label((Composite)incrementalGroup, 0);
        incrementalLabel.setText("Models to be reused");
        this.sameFolderButton = new Button((Composite)incrementalGroup, 16);
        this.sameFolderButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_ReuseFromFolderLabel);
        this.sameWorkspaceButton = new Button((Composite)incrementalGroup, 16);
        this.sameWorkspaceButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_ReuseFromWorkspaceLabel);
        this.modelReuseButton = new Button((Composite)incrementalGroup, 16);
        this.modelReuseButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_ReuseFromResourceReuseLabel);
        this.settingsButton = new Button((Composite)incrementalGroup, 8);
        this.settingsButton.setText("Settings...");
        this.settingsButton.setEnabled(false);
        this.settingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceReuseSettingsDialog dialog = new ResourceReuseSettingsDialog(IntrospectionWizardFirstPage.this.getShell());
                int okPressed = dialog.open();
                if (okPressed == 0) {
                    IntrospectionWizardFirstPage.this.criteria = dialog.getCriteria();
                }
            }
        });
        if (this.incremantalIntrospectionButton.getSelection()) {
            this.setUpIncrementalButtonsAccordingToCurrentPreferences();
        } else {
            this.disableIncrementalButtons();
        }
        this.modelReuseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                IntrospectionWizardFirstPage.this.settingsButton.setEnabled(buttonSelection);
            }
        });
        this.incremantalIntrospectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                IntrospectionWizardFirstPage.this.sameFolderButton.setEnabled(buttonSelection);
                IntrospectionWizardFirstPage.this.sameWorkspaceButton.setEnabled(buttonSelection);
                IntrospectionWizardFirstPage.this.modelReuseButton.setEnabled(buttonSelection);
                if (IntrospectionWizardFirstPage.this.modelReuseButton.getSelection()) {
                    IntrospectionWizardFirstPage.this.settingsButton.setEnabled(buttonSelection);
                }
            }
        });
    }

    private void setUpIncrementalButtonsAccordingToCurrentPreferences() {
        String incrementalIntrospection;
        switch (incrementalIntrospection = IntrospectorPreferenceUtils.getIncrementalIntrospection()) {
            case "reuseFromFolder": {
                this.sameFolderButton.setSelection(true);
                break;
            }
            case "reuseFromWorkspace": {
                this.sameWorkspaceButton.setSelection(true);
                break;
            }
            case "reuseFromResourceReuse": {
                this.modelReuseButton.setSelection(true);
                this.settingsButton.setEnabled(true);
                break;
            }
        }
    }

    private void disableIncrementalButtons() {
        this.sameFolderButton.setEnabled(false);
        this.sameWorkspaceButton.setEnabled(false);
        this.modelReuseButton.setEnabled(false);
    }

    public SearchCriteria getCriteria() {
        return this.criteria;
    }

    public String getSpecifiedFilterRegex() {
        String text;
        String result = text = this.filterText.getText();
        if (text.contains("*")) {
            result = text.substring(0, text.length() - 2);
        }
        return result;
    }

    private void createPerimeterGroup(Composite container) {
        Group perimeterGroup = new Group(container, 4);
        perimeterGroup.setText("Introspection Perimeter");
        perimeterGroup.setLayoutData((Object)new GridData(1808));
        GridLayout specLayout = new GridLayout();
        specLayout.numColumns = 1;
        perimeterGroup.setLayout((Layout)specLayout);
        Label perimeterLabel = new Label((Composite)perimeterGroup, 0);
        perimeterLabel.setText("Shall be introspected");
        this.perimeterPlatformOnlyButton = new Button((Composite)perimeterGroup, 16);
        this.perimeterPlatformOnlyButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_PerimeterIsPlatformOnlyLabel);
        this.workspaceOnlyButton = new Button((Composite)perimeterGroup, 16);
        this.workspaceOnlyButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_PerimeterIsWorkspaceOnlyLabel);
        this.bothButton = new Button((Composite)perimeterGroup, 16);
        this.bothButton.setText(EclipseIntrospectionPreferencePageMessages.EclipseIntrospectionPreferencePage_PerimeterIsPlatformAndWorkspaceLabel);
        this.filterButton = new Button((Composite)perimeterGroup, 32);
        this.filterButton.setText("Filter Introspection Result Model");
        this.filterText = new Text((Composite)perimeterGroup, 2048);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.setVisible(true);
        this.filterText.setEnabled(false);
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                IntrospectionWizardFirstPage.this.filterText.setEnabled(buttonSelection);
            }
        });
        TextContentAdapter contentAdapter = new TextContentAdapter();
        contentAdapter.setCursorPosition((Control)this.filterText, 0);
        SimpleContentProposalProvider stringProvider = new SimpleContentProposalProvider(this.getProposals());
        stringProvider.setFiltering(true);
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.filterText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)stringProvider, null, new char[0], true);
        adapter.setEnabled(true);
        adapter.setProposalAcceptanceStyle(2);
        this.setUpPerimeterButtonsAccordingToCurrentPreferences();
    }

    private String[] getProposals() {
        IPluginModelBase[] allModels = PluginRegistry.getAllModels();
        ArrayList<String> allPluginsID = new ArrayList<String>();
        IPluginModelBase[] iPluginModelBaseArray = allModels;
        int n = allModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n2];
            String pluginId = iPluginModelBase.getPluginBase().getId();
            this.findAlternativesProposals(pluginId, allPluginsID, 0);
            if (!allPluginsID.contains(pluginId)) {
                allPluginsID.add(pluginId);
            }
            ++n2;
        }
        String[] result = allPluginsID.toArray(new String[allPluginsID.size()]);
        return result;
    }

    private void findAlternativesProposals(String pluginId, List<String> proposals, int pos) {
        String[] splitedId = pluginId.split("\\.");
        int length = splitedId.length;
        String alternativeId = "";
        int i = 0;
        while (i <= pos) {
            alternativeId = i != pos ? String.valueOf(alternativeId) + splitedId[i] + "." : (pos < length - 1 ? String.valueOf(alternativeId) + splitedId[i] + ".*" : String.valueOf(alternativeId) + splitedId[i]);
            ++i;
        }
        if (!proposals.contains(alternativeId)) {
            proposals.add(alternativeId);
        }
        if (++pos >= length - 1) {
            return;
        }
        this.findAlternativesProposals(pluginId, proposals, pos);
    }

    private void setUpPerimeterButtonsAccordingToCurrentPreferences() {
        String introspectionPerimeter;
        switch (introspectionPerimeter = IntrospectorPreferenceUtils.getIntrospectionPerimeter()) {
            case "platformOnly": {
                this.perimeterPlatformOnlyButton.setSelection(true);
                break;
            }
            case "workspaceOnly": {
                this.workspaceOnlyButton.setSelection(true);
                break;
            }
            case "platformAndWorkspace": {
                this.bothButton.setSelection(true);
                break;
            }
            default: {
                this.perimeterPlatformOnlyButton.setSelection(true);
            }
        }
    }

    public String getIntrospectionPerimeter() {
        String result = "";
        result = this.perimeterPlatformOnlyButton.getSelection() ? "platform" : (this.workspaceOnlyButton.getSelection() ? "workspace" : "both");
        return result;
    }

    public boolean isIncremental() {
        return this.incremantalIntrospectionButton.getSelection();
    }

    public String getIncrementalIntrospectionType() {
        String result = "";
        result = this.sameFolderButton.getSelection() ? "sameFolder" : (this.sameWorkspaceButton.getSelection() ? "sameWorkspace" : "modelreuse");
        return result;
    }

    public boolean createPackages() {
        return this.createPackageButton.getSelection();
    }

    public boolean storeIntrospectionIssues() {
        return this.storeIssuesButton.getSelection();
    }

    public boolean ignoreQualifier() {
        return this.ignoreQualifierButton.getSelection();
    }
}

