/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.status;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.status.LedManager;
import org.eclipse.kura.gpio.GPIOService;
import org.eclipse.kura.gpio.KuraClosedDeviceException;
import org.eclipse.kura.gpio.KuraGPIODeviceException;
import org.eclipse.kura.gpio.KuraGPIODirection;
import org.eclipse.kura.gpio.KuraGPIOMode;
import org.eclipse.kura.gpio.KuraGPIOPin;
import org.eclipse.kura.gpio.KuraGPIOTrigger;
import org.eclipse.kura.gpio.KuraUnavailableDeviceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpioLedManager
implements LedManager {
    private static final Logger logger = LoggerFactory.getLogger(GpioLedManager.class);
    private final GpioIdentifier identifier;
    private final GPIOService gpioService;
    private final boolean inverted;

    public GpioLedManager(GPIOService gpioService, GpioIdentifier identifier) {
        this(gpioService, identifier, false);
    }

    public GpioLedManager(GPIOService gpioService, GpioIdentifier identifier, boolean inverted) {
        this.identifier = identifier;
        this.gpioService = gpioService;
        this.inverted = inverted;
    }

    @Override
    public void writeLed(boolean enabled) throws KuraException {
        KuraGPIOPin notificationLED = this.identifier instanceof GpioTerminal ? this.gpioService.getPinByTerminal(((GpioTerminal)this.identifier).getNumber(), KuraGPIODirection.OUTPUT, KuraGPIOMode.OUTPUT_OPEN_DRAIN, KuraGPIOTrigger.NONE) : this.gpioService.getPinByName(((GpioName)this.identifier).getName(), KuraGPIODirection.OUTPUT, KuraGPIOMode.OUTPUT_OPEN_DRAIN, KuraGPIOTrigger.NONE);
        try {
            if (!notificationLED.isOpen()) {
                notificationLED.open();
                logger.info("CloudConnectionStatus active on LED {}.", (Object)this.identifier);
            }
            notificationLED.setValue(enabled ^ this.inverted);
        }
        catch (IOException | KuraGPIODeviceException | KuraUnavailableDeviceException throwable) {
            logger.error("Error activating CloudConnectionStatus LED!");
            throw new KuraException(KuraErrorCode.UNAVAILABLE_DEVICE);
        }
        catch (KuraClosedDeviceException kuraClosedDeviceException) {
            logger.error("Error accessing to the specified LED!");
            throw new KuraException(KuraErrorCode.UNAVAILABLE_DEVICE);
        }
    }

    public static interface GpioIdentifier {
    }

    public static class GpioName
    implements GpioIdentifier {
        private final String name;

        public GpioName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GpioName)) {
                return false;
            }
            GpioName other = (GpioName)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    public static class GpioTerminal
    implements GpioIdentifier {
        private final int number;

        public GpioTerminal(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            return Integer.toString(this.number);
        }

        public int hashCode() {
            return Objects.hash(this.number);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GpioTerminal)) {
                return false;
            }
            GpioTerminal other = (GpioTerminal)obj;
            return this.number == other.number;
        }
    }
}

