/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.keystore.BaseKeystoreService;
import org.eclipse.kura.core.keystore.KeystoreInstance;
import org.eclipse.kura.core.keystore.PKCS11KeystoreServiceOptions;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS11KeystoreServiceImpl
extends BaseKeystoreService {
    private static final Logger logger = LoggerFactory.getLogger(PKCS11KeystoreServiceImpl.class);
    Optional<Provider> provider = Optional.empty();
    private PKCS11KeystoreServiceOptions options;
    private CryptoService cryptoService;
    private SystemService systemService;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void activate(ComponentContext context, Map<String, Object> properties) {
        super.activate(context, properties);
        this.options = new PKCS11KeystoreServiceOptions(properties, this.ownPid);
    }

    @Override
    public void updated(Map<String, Object> properties) {
        super.updated(properties);
        PKCS11KeystoreServiceOptions newOptions = new PKCS11KeystoreServiceOptions(properties, this.ownPid);
        if (!newOptions.equals(this.options)) {
            logger.info("Options changed...");
            this.removeProvider();
            this.options = newOptions;
        }
    }

    @Override
    public void deactivate() {
        this.removeProvider();
        super.deactivate();
    }

    @Override
    protected KeystoreInstance loadKeystore() throws KuraException {
        Provider currentProvider = this.getOrRegisterProvider();
        try {
            KeyStore store = KeyStore.getInstance("PKCS11", currentProvider);
            char[] pin = this.options.getPin(this.cryptoService).orElse(null);
            store.load(null, pin);
            return new KeystoreInstanceImpl(store, pin);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.removeProvider();
            logger.warn("Keystore exception", (Throwable)e);
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
    }

    @Override
    protected void saveKeystore(KeystoreInstance keystore) {
    }

    @Override
    public void setEntry(String alias, KeyStore.Entry entry) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void deleteEntry(String alias) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void createKeyPair(String alias, String algorithm, AlgorithmParameterSpec algorithmParameter, String signatureAlgorithm, String attributes) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void createKeyPair(String alias, String algorithm, AlgorithmParameterSpec algorithmParameter, String signatureAlgorithm, String attributes, SecureRandom secureRandom) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes, SecureRandom secureRandom) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    @Override
    protected String getCrlStorePath() {
        return this.options.getCrlStorePath().orElseGet(() -> String.valueOf(this.systemService.getKuraUserConfigDirectory()) + "/security/pkcs11." + this.ownPid + ".crl");
    }

    private synchronized Provider getOrRegisterProvider() throws KuraException {
        if (this.provider.isPresent()) {
            return this.provider.get();
        }
        logger.info("Registering provider...");
        String config = this.options.buildSunPKCS11ProviderConfig().orElseThrow(() -> new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_UNDEFINED, new Object[]{"library.path"}));
        logger.debug("PKCS11 config: {}", (Object)config);
        String javaVersion = System.getProperty("java.version");
        Provider newProvider = javaVersion.startsWith("1.") ? this.registerProviderJava8(config) : this.registerProviderJava9(config);
        this.provider = Optional.of(newProvider);
        logger.info("Registering provider...done");
        return newProvider;
    }

    private Provider registerProviderJava8(String config) throws KuraException {
        try {
            Class<?> providerClass = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> ctor = providerClass.getConstructor(InputStream.class);
            Provider newProvider = (Provider)ctor.newInstance(new ByteArrayInputStream(config.getBytes()));
            Security.addProvider(newProvider);
            return newProvider;
        }
        catch (Exception e) {
            logger.warn("failed to load PKCS11 provider", (Throwable)e);
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE);
        }
    }

    private Provider registerProviderJava9(String config) throws KuraException {
        Provider provider;
        Provider newProvider = Security.getProvider("SunPKCS11");
        Method configure = Provider.class.getMethod("configure", String.class);
        File configFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream out = new FileOutputStream(configFile);){
                ((OutputStream)out).write(config.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            newProvider = (Provider)configure.invoke((Object)newProvider, configFile.getAbsolutePath());
            Security.addProvider(newProvider);
            provider = newProvider;
        }
        catch (Throwable throwable) {
            try {
                Files.deleteIfExists(configFile.toPath());
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("failed to load PKCS11 provider", (Throwable)e);
                throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE);
            }
        }
        Files.deleteIfExists(configFile.toPath());
        return provider;
    }

    private synchronized void removeProvider() {
        if (!this.provider.isPresent()) {
            return;
        }
        logger.info("Removing provider...");
        Security.removeProvider(this.provider.get().getName());
        this.provider = Optional.empty();
        logger.info("Removing provider...done");
    }

    private class KeystoreInstanceImpl
    implements KeystoreInstance {
        private final KeyStore keystore;
        private final char[] password;

        KeystoreInstanceImpl(KeyStore keystore, char[] password) {
            this.keystore = keystore;
            this.password = password;
        }

        @Override
        public KeyStore getKeystore() {
            return this.keystore;
        }

        @Override
        public char[] getPassword() {
            return this.password;
        }
    }
}

