/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.container.orchestration.ContainerConfiguration;
import org.eclipse.kura.container.orchestration.ContainerNetworkConfiguration;
import org.eclipse.kura.container.orchestration.ContainerPort;
import org.eclipse.kura.container.orchestration.ImageConfiguration;
import org.eclipse.kura.container.orchestration.PasswordRegistryCredentials;
import org.eclipse.kura.container.orchestration.PortInternetProtocol;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.eclipse.kura.util.configuration.Property;

public class ContainerInstanceOptions {
    private static final Property<Boolean> IS_ENABLED = new Property("container.enabled", (Object)false);
    private static final Property<String> CONTAINER_IMAGE = new Property("container.image", (Object)"nginx");
    private static final Property<String> CONTAINER_IMAGE_TAG = new Property("container.image.tag", (Object)"latest");
    private static final Property<String> CONTAINER_NAME = new Property("kura.service.pid", (Object)"kura_test_container");
    private static final Property<String> CONTAINER_PORTS_EXTERNAL = new Property("container.ports.external", (Object)"");
    private static final Property<String> CONTAINER_PORTS_INTERNAL = new Property("container.ports.internal", (Object)"");
    private static final Property<String> CONTAINER_ENV = new Property("container.env", (Object)"");
    private static final Property<String> CONTAINER_VOLUME = new Property("container.volume", (Object)"");
    private static final Property<String> CONTAINER_DEVICE = new Property("container.device", (Object)"");
    private static final Property<Boolean> CONTAINER_PRIVILEGED = new Property("container.privileged", (Object)false);
    private static final Property<Integer> CONTAINER_IMAGE_DOWNLOAD_RETRIES = new Property("container.image.download.retries", (Object)5);
    private static final Property<Integer> CONTAINER_IMAGE_DOWNLOAD_RETRY_INTERVAL = new Property("container.image.download.interval", (Object)30000);
    private static final Property<String> CONTAINER_LOGGER_PARAMETERS = new Property("container.loggerParameters", (Object)"");
    private static final Property<String> CONTAINER_LOGGING_TYPE = new Property("container.loggingType", (Object)"default");
    private static final Property<String> REGISTRY_URL = new Property("registry.hostname", (Object)"");
    private static final Property<String> REGISTRY_USERNAME = new Property("registry.username", (Object)"");
    private static final Property<String> REGISTRY_PASSWORD = new Property("registry.password", (Object)"");
    private static final Property<Integer> IMAGES_DOWNLOAD_TIMEOUT = new Property("container.image.download.timeout", (Object)500);
    private static final Property<String> CONTAINER_NETWORKING_MODE = new Property("container.networkMode", (Object)"");
    private static final Property<String> CONTAINER_ENTRY_POINT = new Property("container.entrypoint", (Object)"");
    private static final Property<Boolean> CONTAINER_RESTART_FAILURE = new Property("container.restart.onfailure", (Object)false);
    private static final Property<String> CONTAINER_MEMORY = new Property("container.memory", (Object)"");
    private static final Property<Float> CONTAINER_CPUS = new Property("container.cpus", (Object)Float.valueOf(1.0f));
    private static final Property<String> CONTAINER_GPUS = new Property("container.gpus", (Object)"all");
    private static final Property<String> CONTAINER_RUNTIME = new Property("container.runtime", (Object)"");
    private static final Property<String> SIGNATURE_TRUST_ANCHOR = new Property("container.signature.trust.anchor", (Object)"");
    private static final Property<Boolean> SIGNATURE_VERIFY_TLOG = new Property("container.signature.verify.transparency.log", (Object)true);
    private static final Property<String> ENFORCEMENT_DIGEST = new Property("container.signature.enforcement.digest", (Object)"");
    private boolean enabled;
    private final String image;
    private final String imageTag;
    private final String containerName;
    private final List<Integer> internalPorts;
    private final List<Integer> externalPorts;
    private final List<PortInternetProtocol> containerPortProtocol;
    private final String containerEnv;
    private final String containerVolumeString;
    private final String containerDevice;
    private final boolean privilegedMode;
    private final Map<String, String> containerVolumes;
    private final int maxDownloadRetries;
    private final int retryInterval;
    private final Map<String, String> containerLoggingParameters;
    private final String containerLoggerType;
    private final Optional<String> registryURL;
    private final Optional<String> registryUsername;
    private final Optional<String> registryPassword;
    private final int imageDownloadTimeout;
    private final Optional<String> containerNetworkingMode;
    private final List<String> containerEntryPoint;
    private final boolean restartOnFailure;
    private final Optional<Long> containerMemory;
    private final Optional<Float> containerCpus;
    private final Optional<String> containerGpus;
    private final Optional<String> containerRuntime;
    private final Optional<String> signatureTrustAnchor;
    private final Boolean signatureVerifyTransparencyLog;
    private final Optional<String> enforcementDigest;

    public ContainerInstanceOptions(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        this.enabled = (Boolean)IS_ENABLED.get(properties);
        this.image = (String)CONTAINER_IMAGE.get(properties);
        this.imageTag = (String)CONTAINER_IMAGE_TAG.get(properties);
        this.containerName = (String)CONTAINER_NAME.get(properties);
        this.internalPorts = this.parsePortString((String)CONTAINER_PORTS_INTERNAL.get(properties));
        this.containerPortProtocol = this.parsePortStringProtocol((String)CONTAINER_PORTS_INTERNAL.get(properties));
        this.externalPorts = this.parsePortString((String)CONTAINER_PORTS_EXTERNAL.get(properties));
        this.containerEnv = (String)CONTAINER_ENV.get(properties);
        this.containerVolumeString = (String)CONTAINER_VOLUME.get(properties);
        this.containerVolumes = this.parseVolume(this.containerVolumeString);
        this.containerDevice = (String)CONTAINER_DEVICE.get(properties);
        this.privilegedMode = (Boolean)CONTAINER_PRIVILEGED.get(properties);
        this.maxDownloadRetries = (Integer)CONTAINER_IMAGE_DOWNLOAD_RETRIES.get(properties);
        this.retryInterval = (Integer)CONTAINER_IMAGE_DOWNLOAD_RETRY_INTERVAL.get(properties);
        this.containerLoggerType = (String)CONTAINER_LOGGING_TYPE.get(properties);
        this.containerLoggingParameters = this.parseLoggingParams((String)CONTAINER_LOGGER_PARAMETERS.get(properties));
        this.registryURL = REGISTRY_URL.getOptional(properties);
        this.registryUsername = REGISTRY_USERNAME.getOptional(properties);
        this.registryPassword = REGISTRY_PASSWORD.getOptional(properties);
        this.imageDownloadTimeout = (Integer)IMAGES_DOWNLOAD_TIMEOUT.get(properties);
        this.containerNetworkingMode = CONTAINER_NETWORKING_MODE.getOptional(properties);
        this.containerEntryPoint = this.parseStringListSplitByComma((String)CONTAINER_ENTRY_POINT.get(properties));
        this.restartOnFailure = (Boolean)CONTAINER_RESTART_FAILURE.get(properties);
        this.containerMemory = this.parseMemoryString(CONTAINER_MEMORY.getOptional(properties));
        this.containerCpus = CONTAINER_CPUS.getOptional(properties);
        this.containerGpus = this.parseOptionalString(CONTAINER_GPUS.getOptional(properties));
        this.containerRuntime = this.parseOptionalString(CONTAINER_RUNTIME.getOptional(properties));
        this.signatureTrustAnchor = this.parseOptionalString(SIGNATURE_TRUST_ANCHOR.getOptional(properties));
        this.signatureVerifyTransparencyLog = (Boolean)SIGNATURE_VERIFY_TLOG.get(properties);
        this.enforcementDigest = this.parseOptionalString(ENFORCEMENT_DIGEST.getOptional(properties));
    }

    private Map<String, String> parseVolume(String volumeString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.containerVolumeString.isEmpty()) {
            return map;
        }
        String[] stringArray = volumeString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] tempEntry = entry.split(":");
            if (tempEntry.length == 2) {
                map.put(tempEntry[0].trim(), tempEntry[1].trim());
            }
            ++n2;
        }
        return map;
    }

    private Map<String, String> parseLoggingParams(String loggingString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (loggingString.isEmpty()) {
            return map;
        }
        String[] stringArray = loggingString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] tempEntry = entry.split("=");
            if (tempEntry.length == 2) {
                map.put(tempEntry[0].trim(), tempEntry[1].trim());
            }
            ++n2;
        }
        return map;
    }

    private List<String> parseEnvVars(String containerVolumeString) {
        LinkedList<String> envList = new LinkedList<String>();
        if (containerVolumeString.isEmpty()) {
            return envList;
        }
        String[] stringArray = containerVolumeString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            envList.add(entry.trim());
            ++n2;
        }
        return envList;
    }

    private List<String> parseStringListSplitByComma(String stringToSplit) {
        LinkedList<String> stringList = new LinkedList<String>();
        if (stringToSplit.isEmpty()) {
            return stringList;
        }
        String[] stringArray = stringToSplit.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.trim().length() > 0) {
                stringList.add(entry.trim());
            }
            ++n2;
        }
        return stringList;
    }

    private Optional<Long> parseMemoryString(Optional<String> value) {
        if (value.isPresent() && !value.get().trim().isEmpty()) {
            String stringValue = value.get().trim();
            long result = 0L;
            switch (stringValue.charAt(stringValue.length() - 1)) {
                case 'b': {
                    result = Long.parseLong(stringValue.substring(0, stringValue.length() - 1));
                    break;
                }
                case 'k': {
                    result = Long.parseLong(stringValue.substring(0, stringValue.length() - 1)) * 1024L;
                    break;
                }
                case 'm': {
                    result = Long.parseLong(stringValue.substring(0, stringValue.length() - 1)) * 0x100000L;
                    break;
                }
                case 'g': {
                    result = Long.parseLong(stringValue.substring(0, stringValue.length() - 1)) * 0x40000000L;
                    break;
                }
                default: {
                    result = Long.parseLong(stringValue);
                }
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<String> parseOptionalString(Optional<String> optionalString) {
        if (optionalString.isPresent() && optionalString.get().isEmpty()) {
            return Optional.empty();
        }
        return optionalString;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getContainerImage() {
        return this.image;
    }

    public String getContainerImageTag() {
        return this.imageTag;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public List<Integer> getContainerPortsInternal() {
        return this.internalPorts;
    }

    public List<Integer> getContainerPortsExternal() {
        return this.externalPorts;
    }

    public Map<String, String> getContainerVolumeList() {
        return this.parseVolume(this.containerVolumeString);
    }

    public List<String> getContainerEnvList() {
        return this.parseEnvVars(this.containerEnv);
    }

    public List<String> getContainerDeviceList() {
        return this.parseStringListSplitByComma(this.containerDevice);
    }

    public boolean getPrivilegedMode() {
        return this.privilegedMode;
    }

    public boolean isUnlimitedRetries() {
        return this.maxDownloadRetries == 0;
    }

    public int getMaxDownloadRetries() {
        return this.maxDownloadRetries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public String getLoggingType() {
        return this.containerLoggerType;
    }

    public boolean getRestartOnFailure() {
        return this.restartOnFailure;
    }

    public Map<String, String> getLoggerParameters() {
        return this.containerLoggingParameters;
    }

    public Optional<String> getContainerNetworkingMode() {
        return this.containerNetworkingMode;
    }

    public Optional<RegistryCredentials> getRegistryCredentials() {
        if (this.registryUsername.isPresent() && this.registryPassword.isPresent()) {
            return Optional.of(new PasswordRegistryCredentials(this.registryURL, this.registryUsername.get(), new Password(this.registryPassword.get())));
        }
        return Optional.empty();
    }

    public int getImageDownloadTimeout() {
        return this.imageDownloadTimeout;
    }

    private ContainerNetworkConfiguration buildContainerNetworkConfig() {
        return new ContainerNetworkConfiguration.ContainerNetworkConfigurationBuilder().setNetworkMode(this.getContainerNetworkingMode()).build();
    }

    public List<String> getEntryPoint() {
        return this.containerEntryPoint;
    }

    public Optional<Long> getMemory() {
        return this.containerMemory;
    }

    public Optional<Float> getCpus() {
        return this.containerCpus;
    }

    public Optional<String> getGpus() {
        return this.containerGpus;
    }

    public Optional<String> getRuntime() {
        return this.containerRuntime;
    }

    public Optional<String> getSignatureTrustAnchor() {
        return this.signatureTrustAnchor;
    }

    public Boolean getSignatureVerifyTransparencyLog() {
        return this.signatureVerifyTransparencyLog;
    }

    public Optional<String> getEnforcementDigest() {
        return this.enforcementDigest;
    }

    private ImageConfiguration buildImageConfig() {
        return new ImageConfiguration.ImageConfigurationBuilder().setImageName(this.image).setImageTag(this.imageTag).setImageDownloadTimeoutSeconds(this.imageDownloadTimeout).setRegistryCredentials(this.getRegistryCredentials()).build();
    }

    private ContainerConfiguration.ContainerConfigurationBuilder buildPortConfig(ContainerConfiguration.ContainerConfigurationBuilder cc) {
        LinkedList<ContainerPort> containerPorts = new LinkedList<ContainerPort>();
        Iterator<Integer> internalIt = this.internalPorts.iterator();
        Iterator<Integer> externalIt = this.externalPorts.iterator();
        Iterator<PortInternetProtocol> ipIt = this.containerPortProtocol.iterator();
        while (externalIt.hasNext() && internalIt.hasNext() && ipIt.hasNext()) {
            containerPorts.add(new ContainerPort(internalIt.next().intValue(), externalIt.next().intValue(), ipIt.next()));
        }
        cc.setContainerPorts(containerPorts);
        return cc;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.buildPortConfig(ContainerConfiguration.builder()).setContainerName(this.getContainerName()).setImageConfiguration(this.buildImageConfig()).setEnvVars(this.getContainerEnvList()).setVolumes(this.getContainerVolumeList()).setPrivilegedMode(Boolean.valueOf(this.privilegedMode)).setDeviceList(this.getContainerDeviceList()).setFrameworkManaged(Boolean.valueOf(true)).setLoggingType(this.getLoggingType()).setContainerNetowrkConfiguration(this.buildContainerNetworkConfig()).setLoggerParameters(this.getLoggerParameters()).setEntryPoint(this.getEntryPoint()).setRestartOnFailure(this.getRestartOnFailure()).setMemory(this.getMemory()).setCpus(this.getCpus()).setGpus(this.getGpus()).setRuntime(this.getRuntime()).setEnforcementDigest(this.getEnforcementDigest()).build();
    }

    private List<Integer> parsePortString(String ports) {
        ArrayList<Integer> tempArray = new ArrayList<Integer>();
        if (!ports.isEmpty()) {
            String[] tempString;
            String[] stringArray = tempString = ports.trim().replace(" ", "").split(",");
            int n = tempString.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                tempArray.add(Integer.parseInt(element.trim().replace("-", "").split(":")[0]));
                ++n2;
            }
        }
        return tempArray;
    }

    private List<PortInternetProtocol> parsePortStringProtocol(String ports) {
        ArrayList<PortInternetProtocol> tempArray;
        block11: {
            tempArray = new ArrayList<PortInternetProtocol>();
            if (ports.isEmpty()) break block11;
            String[] stringArray = ports.trim().replace(" ", "").split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    block12: {
                        String portToken = stringArray[n2];
                        if (portToken.split(":").length <= 1) break block12;
                        switch (portToken.split(":")[1].toUpperCase().trim()) {
                            case "UDP": {
                                tempArray.add(PortInternetProtocol.UDP);
                                break;
                            }
                            case "SCTP": {
                                tempArray.add(PortInternetProtocol.SCTP);
                                break;
                            }
                            default: {
                                tempArray.add(PortInternetProtocol.TCP);
                                break;
                            }
                        }
                        break block14;
                    }
                    tempArray.add(PortInternetProtocol.TCP);
                }
                ++n2;
            }
        }
        return tempArray;
    }

    public int hashCode() {
        return Objects.hash(this.containerCpus, this.containerDevice, this.containerEntryPoint, this.containerEnv, this.containerGpus, this.containerLoggerType, this.containerLoggingParameters, this.containerMemory, this.containerName, this.containerNetworkingMode, this.containerPortProtocol, this.containerRuntime, this.containerVolumeString, this.containerVolumes, this.enabled, this.enforcementDigest, this.externalPorts, this.image, this.imageDownloadTimeout, this.imageTag, this.internalPorts, this.maxDownloadRetries, this.privilegedMode, this.registryPassword, this.registryURL, this.registryUsername, this.restartOnFailure, this.retryInterval, this.signatureTrustAnchor, this.signatureVerifyTransparencyLog);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerInstanceOptions other = (ContainerInstanceOptions)obj;
        return Objects.equals(this.containerCpus, other.containerCpus) && Objects.equals(this.containerDevice, other.containerDevice) && Objects.equals(this.containerEntryPoint, other.containerEntryPoint) && Objects.equals(this.containerEnv, other.containerEnv) && Objects.equals(this.containerGpus, other.containerGpus) && Objects.equals(this.containerLoggerType, other.containerLoggerType) && Objects.equals(this.containerLoggingParameters, other.containerLoggingParameters) && Objects.equals(this.containerMemory, other.containerMemory) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerNetworkingMode, other.containerNetworkingMode) && Objects.equals(this.containerPortProtocol, other.containerPortProtocol) && Objects.equals(this.containerVolumeString, other.containerVolumeString) && Objects.equals(this.containerVolumes, other.containerVolumes) && this.enabled == other.enabled && Objects.equals(this.enforcementDigest, other.enforcementDigest) && Objects.equals(this.externalPorts, other.externalPorts) && Objects.equals(this.image, other.image) && this.imageDownloadTimeout == other.imageDownloadTimeout && Objects.equals(this.imageTag, other.imageTag) && Objects.equals(this.internalPorts, other.internalPorts) && this.maxDownloadRetries == other.maxDownloadRetries && this.privilegedMode == other.privilegedMode && Objects.equals(this.registryPassword, other.registryPassword) && Objects.equals(this.registryURL, other.registryURL) && Objects.equals(this.registryUsername, other.registryUsername) && this.restartOnFailure == other.restartOnFailure && this.retryInterval == other.retryInterval && Objects.equals(this.containerRuntime, other.containerRuntime) && Objects.equals(this.signatureTrustAnchor, other.signatureTrustAnchor) && Objects.equals(this.signatureVerifyTransparencyLog, other.signatureVerifyTransparencyLog);
    }
}

