/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.position.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.kura.position.GNSSType;
import org.osgi.util.position.Position;

public class PositionDTO {
    private Double longitude;
    private Double latitude;
    private Double altitude;
    private Double speed;
    private Double track;
    private Set<String> gnssType;

    public PositionDTO(Position position, Set<GNSSType> gnssTypeSet) {
        if (position.getLongitude() != null) {
            this.longitude = Math.toDegrees(position.getLongitude().getValue());
        }
        if (position.getLatitude() != null) {
            this.latitude = Math.toDegrees(position.getLatitude().getValue());
        }
        if (position.getAltitude() != null) {
            this.altitude = position.getAltitude().getValue();
        }
        if (position.getSpeed() != null) {
            this.speed = position.getSpeed().getValue();
        }
        if (position.getTrack() != null) {
            this.track = Math.toDegrees(position.getTrack().getValue());
        }
        if (gnssTypeSet != null) {
            this.gnssType = new HashSet<String>();
            for (GNSSType type : gnssTypeSet) {
                this.gnssType.add(type.getValue());
            }
        }
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public Double getTrack() {
        return this.track;
    }

    public Set<String> getGnssType() {
        return this.gnssType;
    }
}

