/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractCacheBasedTest {
    protected Path testWorkDirectory = null;
    private final String uuid = UUID.randomUUID().toString();
    private static Path parentDir;

    @BeforeEach
    public final void setupCache() throws Exception {
        this.clearCache();
        FilesUtils.resetDeployPath();
        Assertions.assertNotNull((Object)parentDir);
        Path childDir = parentDir.resolve(this.uuid);
        this.testWorkDirectory = Files.createDirectory(childDir, new FileAttribute[0]);
        System.setProperty("lemminx.workdir", this.testWorkDirectory.toAbsolutePath().toString());
    }

    @AfterEach
    public final void clearCache() throws IOException {
        if (this.testWorkDirectory != null && Files.exists(this.testWorkDirectory, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)this.testWorkDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            Files.delete(this.testWorkDirectory);
        }
        System.clearProperty("lemminx.workdir");
        FilesUtils.resetDeployPath();
    }

    static {
        try {
            String cacheInRepoDir = System.getProperty("lemminx.cacheInRepoDir");
            if (StringUtils.isEmpty((String)cacheInRepoDir)) {
                parentDir = Files.createTempDirectory("lemminx", new FileAttribute[0]);
            } else {
                parentDir = Paths.get(System.getProperty("user.home"), "lemminx_test");
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            parentDir = null;
        }
    }
}

