/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.filepath.participants.AbstractFilePathCompletionTest;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class FilePathCompletionWithNoNamespaceSchemaLocationTest
extends AbstractFilePathCompletionTest {
    @Test
    public void empty() throws BadLocationException {
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 32, 32, "folderA", "folderB", "folderC", "NestedA", "main.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void dotSlash() throws BadLocationException {
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"./|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 34, 34, "folderA", "folderB", "folderC", "NestedA", "main.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void dotSlashFollowingBySlash() throws BadLocationException {
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"./|/\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 34, 35, "folderA", "folderB", "folderC", "NestedA", "main.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void backSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\".\\|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 34, 34, "folderA", "folderB", "folderC", "NestedA", "main.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void afterFolderA() throws BadLocationException {
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"./folderA/|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 42, 42, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void afterFolderABackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\".\\folderA\\|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 42, 42, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void afterFolderB() throws BadLocationException {
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"./folderB/|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 42, 42, "xsdB1.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void afterFolderBBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<root-element\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:noNamespaceSchemaLocation=\"./folderB\\|\">\n</root-element>";
        CompletionItem[] items = FilePathCompletionWithNoNamespaceSchemaLocationTest.getCompletionItemList(2, 42, 42, "xsdB1.xsd");
        FilePathCompletionWithNoNamespaceSchemaLocationTest.testCompletionFor(xml, 1, items);
    }
}

