/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsi;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XSICompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void completion() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=|>";
        this.testCompletionFor(xml, XMLAssert.c("true", XMLAssert.te(1, 71, 1, 71, "\"true\""), "\"true\""), XMLAssert.c("false", XMLAssert.te(1, 71, 1, 71, "\"false\""), "\"false\""));
    }

    @Test
    public void completionItemDefaults() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=|>";
        this.testCompletionFor(xml, true, XMLAssert.c("true", XMLAssert.te(1, 71, 1, 71, "\"true\""), "\"true\""), XMLAssert.c("false", XMLAssert.te(1, 71, 1, 71, "\"false\""), "\"false\""));
    }

    @Test
    public void completion2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"|\">";
        this.testCompletionFor(xml, XMLAssert.c("true", XMLAssert.te(1, 72, 1, 72, "true"), "true"), XMLAssert.c("false", XMLAssert.te(1, 72, 1, 72, "false"), "false"));
    }

    @Test
    public void completion3() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\r\n  <a xsi:nil=|> </a> ";
        this.testCompletionFor(xml, XMLAssert.c("true", XMLAssert.te(2, 13, 2, 13, "\"true\""), "\"true\""), XMLAssert.c("false", XMLAssert.te(2, 13, 2, 13, "\"false\""), "\"false\""));
    }

    @Test
    public void completion3NNamespace() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project >\r\n  <a xsi:nil=|> </a> ";
        this.testCompletionFor(xml, new CompletionItem[0]);
    }

    @Test
    public void completion4() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\r\n  <a xsi:nil=|> </a> ";
        this.testCompletionFor(xml, this.singleQuotesSharedSettings(), XMLAssert.c("true", XMLAssert.te(2, 13, 2, 13, "'true'"), "'true'"), XMLAssert.c("false", XMLAssert.te(2, 13, 2, 13, "'false'"), "'false'"));
    }

    @Test
    public void completionXMLNSXSIValue() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=| >\r\n  <a> </a> \r\n</project>";
        this.testCompletionFor(xml, XMLAssert.c("http://www.w3.org/2001/XMLSchema-instance", XMLAssert.te(1, 19, 1, 19, "\"http://www.w3.org/2001/XMLSchema-instance\""), "\"http://www.w3.org/2001/XMLSchema-instance\""));
    }

    @Test
    public void completionXMLNSXSIValueSingleQuotes() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:xsi=| >\r\n  <a> </a> \r\n</project>";
        this.testCompletionFor(xml, this.singleQuotesSharedSettings(), XMLAssert.c("http://www.w3.org/2001/XMLSchema-instance", XMLAssert.te(1, 19, 1, 19, "'http://www.w3.org/2001/XMLSchema-instance'"), "'http://www.w3.org/2001/XMLSchema-instance'"));
    }

    @Test
    public void completionXMLNSXSIWhole() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project xmlns:x| >\r\n  <a> </a> \r\n</project>";
        this.testCompletionFor(xml, XMLAssert.c("xmlns:xsi", XMLAssert.te(1, 9, 1, 16, "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""), "xmlns:xsi"));
    }

    @Test
    public void completionXMLNS() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project x| >\r\n  <a> </a> \r\n</project>";
        this.testCompletionFor(xml, XMLAssert.c("xmlns", XMLAssert.te(1, 9, 1, 10, "xmlns=\"\""), "xmlns"));
    }

    @Test
    public void completionXMLNSOnlyInRoot() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<project>\r\n  <a x|> </a> \r\n</project>";
        this.testCompletionFor(xml, new CompletionItem[0]);
    }

    private SharedSettings singleQuotesSharedSettings() {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        return settings;
    }

    private void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, null, expectedItems);
    }

    private void testCompletionFor(String xml, SharedSettings sharedSettings, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, null, null, null, sharedSettings, expectedItems);
    }

    private void testCompletionFor(String xml, boolean enableItemDefaults, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, null, enableItemDefaults, expectedItems);
    }
}

