/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.List;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.customservice.ActionableNotification;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.MessageParams;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractNotifierTest {
    protected MockXMLLanguageServer languageServer;

    public void before() {
        this.languageServer = new MockXMLLanguageServer();
    }

    protected void setSupportCapabilities(boolean supportActionableNotification, boolean supportOpenSettings) {
        ExtendedClientCapabilities capabilities = new ExtendedClientCapabilities();
        capabilities.setActionableNotificationSupport(supportActionableNotification);
        capabilities.setOpenSettingsCommandSupport(supportOpenSettings);
        this.getTextDocumentService().updateClientCapabilities(new ClientCapabilities(), capabilities);
    }

    protected XMLTextDocumentService getTextDocumentService() {
        return (XMLTextDocumentService)this.languageServer.getTextDocumentService();
    }

    protected void assertCounts(int actionableNotification, int sendMessage) {
        List<ActionableNotification> actionableNotifications = this.languageServer.getActionableNotifications();
        List<MessageParams> showMessages = this.languageServer.getShowMessages();
        Assertions.assertEquals((int)actionableNotification, (int)actionableNotifications.size());
        Assertions.assertEquals((int)sendMessage, (int)showMessages.size());
    }

    protected void assertLastShowMessage(String expectedMessage) {
        List<MessageParams> showMessages = this.languageServer.getShowMessages();
        Assertions.assertEquals((Object)expectedMessage, showMessages.size() > 0 ? showMessages.get(showMessages.size() - 1).getMessage() : null);
    }

    protected void assertLastActionableNotificationMessage(String expectedMessage) {
        List<ActionableNotification> actionableNotifications = this.languageServer.getActionableNotifications();
        Assertions.assertEquals((Object)expectedMessage, actionableNotifications.size() > 0 ? actionableNotifications.get(actionableNotifications.size() - 1).getMessage() : null);
    }
}

