/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.settings.XMLSymbolExpressionFilter;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLDocumentSymbolsTest {
    @Test
    public void externalDTD() {
        String dtd = "<!ELEMENT br EMPTY>\n<!ATTLIST br\n\t%all;>";
        XMLAssert.testDocumentSymbolsFor(dtd, "test.dtd", XMLAssert.ds("br", SymbolKind.Property, XMLAssert.r(0, 0, 0, 19), XMLAssert.r(0, 0, 0, 19), null, Arrays.asList(XMLAssert.ds("%all;", SymbolKind.Key, XMLAssert.r(2, 1, 2, 6), XMLAssert.r(2, 1, 2, 6), null, Arrays.asList(new DocumentSymbol[0])))));
    }

    @Test
    public void multipleAttlistValues() {
        String dtd = "<!ELEMENT target EMPTY>\r\n \r\n<!ATTLIST target\r\n          tid ID #IMPLIED\r\n\r\n<!ATTLIST target\r\n          bee ID #IMPLIED>\r\n        \r\n         \r\n<!ATTLIST extension-point\r\n          ep CDATA #IMPLIED\r\n          ep2 CDATA #IMPLIED>\r\n";
        XMLAssert.testDocumentSymbolsFor(dtd, "test.dtd", XMLAssert.ds("target", SymbolKind.Property, XMLAssert.r(0, 0, 0, 23), XMLAssert.r(0, 0, 0, 23), null, Arrays.asList(XMLAssert.ds("tid", SymbolKind.Key, XMLAssert.r(3, 10, 3, 13), XMLAssert.r(3, 10, 3, 13), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("bee", SymbolKind.Key, XMLAssert.r(6, 10, 6, 13), XMLAssert.r(6, 10, 6, 13), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("extension-point", SymbolKind.Key, XMLAssert.r(9, 0, 11, 29), XMLAssert.r(9, 0, 11, 29), null, Arrays.asList(XMLAssert.ds("ep", SymbolKind.Key, XMLAssert.r(10, 10, 10, 12), XMLAssert.r(10, 10, 10, 12), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("ep2", SymbolKind.Key, XMLAssert.r(11, 10, 11, 13), XMLAssert.r(11, 10, 11, 13), null, Arrays.asList(new DocumentSymbol[0])))));
    }

    @Test
    public void internalDTD() {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT Person (Name,Email?)>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n\t<!ELEMENT Name (#PCDATA)>\r\n\t<!ELEMENT Email (#PCDATA)>\r\n\t]>\r\n<Folks>\r\n\t\r\n</Folks>";
        XMLAssert.testDocumentSymbolsFor(xml, "test.xml", XMLAssert.ds("xml", SymbolKind.Property, XMLAssert.r(0, 0, 0, 23), XMLAssert.r(0, 0, 0, 23), null, Collections.emptyList()), XMLAssert.ds("DOCTYPE:Folks", SymbolKind.Struct, XMLAssert.r(1, 0, 9, 3), XMLAssert.r(1, 0, 9, 3), null, Arrays.asList(XMLAssert.ds("Folks", SymbolKind.Property, XMLAssert.r(2, 1, 2, 27), XMLAssert.r(2, 1, 2, 27), null, Collections.emptyList()), XMLAssert.ds("Person", SymbolKind.Property, XMLAssert.r(3, 1, 3, 32), XMLAssert.r(3, 1, 3, 32), null, Arrays.asList(XMLAssert.ds("Pin", SymbolKind.Key, XMLAssert.r(4, 18, 4, 21), XMLAssert.r(4, 18, 4, 21), null, Collections.emptyList()), XMLAssert.ds("Friend", SymbolKind.Key, XMLAssert.r(5, 18, 5, 24), XMLAssert.r(5, 18, 5, 24), null, Collections.emptyList()), XMLAssert.ds("Likes", SymbolKind.Key, XMLAssert.r(6, 18, 6, 23), XMLAssert.r(6, 18, 6, 23), null, Collections.emptyList()))), XMLAssert.ds("Name", SymbolKind.Property, XMLAssert.r(7, 1, 7, 26), XMLAssert.r(7, 1, 7, 26), null, Collections.emptyList()), XMLAssert.ds("Email", SymbolKind.Property, XMLAssert.r(8, 1, 8, 27), XMLAssert.r(8, 1, 8, 27), null, Collections.emptyList()))), XMLAssert.ds("Folks", SymbolKind.Field, XMLAssert.r(10, 0, 12, 8), XMLAssert.r(10, 0, 12, 8), null, Collections.emptyList()));
    }

    @Test
    public void exceedSymbolLimit() {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT Person (Name,Email?)>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n\t<!ELEMENT Name (#PCDATA)>\r\n\t<!ELEMENT Email (#PCDATA)>\r\n\t]>\r\n<Folks>\r\n\t\r\n</Folks>";
        DocumentSymbol symbol1 = XMLAssert.ds("xml", SymbolKind.Property, XMLAssert.r(0, 0, 0, 23), XMLAssert.r(0, 0, 0, 23), null, Collections.emptyList());
        DocumentSymbol symbol2 = XMLAssert.ds("DOCTYPE:Folks", SymbolKind.Struct, XMLAssert.r(1, 0, 9, 3), XMLAssert.r(1, 0, 9, 3), null, Arrays.asList(XMLAssert.ds("Folks", SymbolKind.Property, XMLAssert.r(2, 1, 2, 27), XMLAssert.r(2, 1, 2, 27), null, Collections.emptyList()), XMLAssert.ds("Person", SymbolKind.Property, XMLAssert.r(3, 1, 3, 32), XMLAssert.r(3, 1, 3, 32), null, Arrays.asList(XMLAssert.ds("Pin", SymbolKind.Key, XMLAssert.r(4, 18, 4, 21), XMLAssert.r(4, 18, 4, 21), null, Collections.emptyList()), XMLAssert.ds("Friend", SymbolKind.Key, XMLAssert.r(5, 18, 5, 24), XMLAssert.r(5, 18, 5, 24), null, Collections.emptyList()), XMLAssert.ds("Likes", SymbolKind.Key, XMLAssert.r(6, 18, 6, 23), XMLAssert.r(6, 18, 6, 23), null, Collections.emptyList()))), XMLAssert.ds("Name", SymbolKind.Property, XMLAssert.r(7, 1, 7, 26), XMLAssert.r(7, 1, 7, 26), null, Collections.emptyList()), XMLAssert.ds("Email", SymbolKind.Property, XMLAssert.r(8, 1, 8, 27), XMLAssert.r(8, 1, 8, 27), null, Collections.emptyList())));
        DocumentSymbol symbol3 = XMLAssert.ds("Folks", SymbolKind.Field, XMLAssert.r(10, 0, 12, 8), XMLAssert.r(10, 0, 12, 8), null, Collections.emptyList());
        XMLSymbolSettings settings = new XMLSymbolSettings();
        settings.setMaxItemsComputed(10);
        XMLAssert.testDocumentSymbolsFor(xml, "test.xml", settings, symbol1, symbol2, symbol3);
        settings.setMaxItemsComputed(15);
        XMLAssert.testDocumentSymbolsFor(xml, "test.xml", settings, symbol1, symbol2, symbol3);
        settings.setMaxItemsComputed(9);
        XMLAssert.testDocumentSymbolsFor(xml, "test.xml", settings, symbol1, symbol2);
    }

    @Test
    public void symbolLimitOfZero() {
        String xml = "<a>\n  <b>\n    <c>\n      <d />\n    </c>\n  </b></a>";
        XMLSymbolSettings settings = new XMLSymbolSettings();
        settings.setMaxItemsComputed(0);
        XMLDocumentSymbolsTest.testDocumentSymbolsNumber(xml, "test.xml", settings, 0);
    }

    private static void testDocumentSymbolsNumber(String xml, String fileURI, XMLSymbolSettings symbolSettings, int expectedNumber) {
        XMLDocumentSymbolsTest.testDocumentSymbolsNumber(new XMLLanguageService(), xml, fileURI, symbolSettings, null, expectedNumber);
    }

    private static void testDocumentSymbolsNumber(XMLLanguageService xmlLanguageService, String xml, String fileURI, XMLSymbolSettings symbolSettings, Consumer<XMLLanguageService> customConfiguration, int expectedNumber) {
        TextDocument document = new TextDocument(xml, fileURI != null ? fileURI : "test.xml");
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        xmlLanguageService.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(settings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDocumentSymbols(xmlDocument, symbolSettings);
        Assertions.assertEquals((int)expectedNumber, (int)actual.size());
    }

    @Test
    public void noSymbolsFilter() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 2, 6), XMLAssert.r(0, 0, 2, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])))));
        symbolSettings = new XMLSymbolSettings();
        symbolSettings.setFilters(new XMLSymbolFilter[0]);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 2, 6), XMLAssert.r(0, 0, 2, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])))));
    }

    @Test
    public void symbolsFilterWithAllAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(XMLAssert.ds("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.r(2, 6, 2, 24), XMLAssert.r(2, 6, 2, 24), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.r(2, 25, 2, 43), XMLAssert.r(2, 25, 2, 43), null, Arrays.asList(new DocumentSymbol[0]))))));
        expressionFilter.setXpath("//@*");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr);
        DocumentSymbol symbolsWithBarAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@*");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr);
        expressionFilter.setXpath("/foo/bar/@*");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr);
    }

    @Test
    public void symbolsFilterWithOneAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr2 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(XMLAssert.ds("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.r(2, 25, 2, 43), XMLAssert.r(2, 25, 2, 43), null, Arrays.asList(new DocumentSymbol[0]))))));
        expressionFilter.setXpath("//@attr2");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2);
        DocumentSymbol symbolsWithBarAttr2 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2);
        expressionFilter.setXpath("/foo/bar/@attr2");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2);
    }

    @Test
    public void symbolsFilterWithText() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolWithAllText = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: ABCD", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz: EFGH", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//text()");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolWithAllText);
        DocumentSymbol symbolWithBarText = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: ABCD", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/text()");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolWithBarText);
        expressionFilter.setXpath("/foo/bar/text()");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolWithBarText);
    }

    @Test
    public void symbolsFilterExcludeElement() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//baz");
        expressionFilter.setExcluded(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])))));
    }

    @Test
    public void symbolsFilterWithNonInlineAttributeShowAttributeName() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr2NoInlineAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(XMLAssert.ds("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.r(2, 25, 2, 43), XMLAssert.r(2, 25, 2, 43), null, Arrays.asList(new DocumentSymbol[0]))))));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2NoInlineAttr);
        DocumentSymbol symbolsWithBarAttr2NoInlineAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr2: value2", SymbolKind.Constant, XMLAssert.r(1, 21, 1, 35), XMLAssert.r(1, 21, 1, 35), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2NoInlineAttr);
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2NoInlineAttr);
    }

    @Test
    public void symbolsFilterWithInlineAttributeNoNestedAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr2InlineAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: @attr2: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz: @attr2: baz-value2", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2InlineAttr);
        DocumentSymbol symbolsWithAllAttr2InlineAttrNoName = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz: baz-value2", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2InlineAttrNoName);
        DocumentSymbol symbolsWithBarAttr2InlineAttr = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: @attr2: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttr);
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttr);
        DocumentSymbol symbolsWithBarAttr2InlineAttrNoName = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrNoName);
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrNoName);
    }

    @Test
    public void symbolsFilterWithInlineAttributeWithNestedAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        XMLSymbolExpressionFilter expressionFilter2 = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter, expressionFilter2});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr2InlineAttrAndNestedAttr1 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: @attr2: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz: @attr2: baz-value2", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(XMLAssert.ds("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.r(2, 6, 2, 24), XMLAssert.r(2, 6, 2, 24), null, Arrays.asList(new DocumentSymbol[0]))))));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("//@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2InlineAttrAndNestedAttr1);
        DocumentSymbol symbolsWithAllAttr2InlineAttrNoNameAndNestedAttr1 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz: baz-value2", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(XMLAssert.ds("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.r(2, 6, 2, 24), XMLAssert.r(2, 6, 2, 24), null, Arrays.asList(new DocumentSymbol[0]))))));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr2InlineAttrNoNameAndNestedAttr1);
        DocumentSymbol symbolsWithBarAttr2InlineAttrAndNestedAttr1 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: @attr2: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("//bar/@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrAndNestedAttr1);
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrAndNestedAttr1);
        DocumentSymbol symbolsWithBarAttr2InlineAttrNoNameAndNestedAttr1 = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 3, 6), XMLAssert.r(0, 0, 3, 6), null, Arrays.asList(XMLAssert.ds("bar: value2", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(XMLAssert.ds("@attr1: value1", SymbolKind.Constant, XMLAssert.r(1, 6, 1, 20), XMLAssert.r(1, 6, 1, 20), null, Arrays.asList(new DocumentSymbol[0])))), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrNoNameAndNestedAttr1);
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr2InlineAttrNoNameAndNestedAttr1);
    }

    @Test
    public void symbolsFilterWithInlineAttributeMultipleInlineAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n\t<bar attr3=\"value3\" attr2=\"value2\">IJKL</bar>\r\n</foo>";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        XMLSymbolExpressionFilter expressionFilter2 = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter, expressionFilter2});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        DocumentSymbol symbolsWithAllAttr1AndAttr3Inline = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 4, 6), XMLAssert.r(0, 0, 4, 6), null, Arrays.asList(XMLAssert.ds("bar: value1", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz: baz-value1", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("bar: @attr3: value3", SymbolKind.Field, XMLAssert.r(3, 1, 3, 46), XMLAssert.r(3, 1, 3, 46), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithAllAttr1AndAttr3Inline);
        DocumentSymbol symbolsWithBarAttr1AndAttr3Inline = XMLAssert.ds("foo", SymbolKind.Field, XMLAssert.r(0, 0, 4, 6), XMLAssert.r(0, 0, 4, 6), null, Arrays.asList(XMLAssert.ds("bar: value1", SymbolKind.Field, XMLAssert.r(1, 1, 1, 46), XMLAssert.r(1, 1, 1, 46), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("baz", SymbolKind.Field, XMLAssert.r(2, 1, 2, 54), XMLAssert.r(2, 1, 2, 54), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("bar: @attr3: value3", SymbolKind.Field, XMLAssert.r(3, 1, 3, 46), XMLAssert.r(3, 1, 3, 46), null, Arrays.asList(new DocumentSymbol[0]))));
        expressionFilter.setXpath("//bar/@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//bar/@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr1AndAttr3Inline);
        expressionFilter.setXpath("/foo/bar/@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/foo.xml", symbolSettings, symbolsWithBarAttr1AndAttr3Inline);
    }
}

