/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.TapsetParser;

public final class SharedParser
extends TapsetParser {
    private static final String[] STAP_OPTIONS = new String[]{"-v", "-p1", "-e"};
    private static final String STAP_DUMMYPROBE = "probe begin{}";
    static final String TAG_FILE = "# file ";
    private static final Pattern FILE_PATTERN = Pattern.compile("# file ".concat("(/.*\\.stp)"));
    private String tapsetContents = null;
    private static SharedParser parser = null;

    static String makeFileTag(String fileName) {
        return TAG_FILE.concat(fileName);
    }

    static String findFileNameInTag(String contents) {
        Matcher matcher = FILE_PATTERN.matcher(contents);
        return matcher.find() ? matcher.group(1) : null;
    }

    public static SharedParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new SharedParser();
        return parser;
    }

    private SharedParser() {
        super(Messages.SharedParser_name);
    }

    public synchronized void clearTapsetContents() {
        this.tapsetContents = null;
    }

    synchronized String getTapsetContents() {
        return this.tapsetContents != null ? this.tapsetContents : this.runAction();
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.createStatus(this.verifyRunResult(this.runAction()));
    }

    private String runAction() {
        String contents = this.runStap(STAP_OPTIONS, STAP_DUMMYPROBE, false);
        if (this.verifyRunResult(contents) == 0) {
            int beginIndex;
            int firstTagIndex = contents.indexOf(TAG_FILE);
            if (firstTagIndex != -1 && (beginIndex = contents.indexOf(TAG_FILE, firstTagIndex + 1)) != -1) {
                this.tapsetContents = contents.substring(beginIndex);
            }
            return this.tapsetContents;
        }
        return contents;
    }
}

