/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.util.EvaluationMonitor;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.Log;

public final class ExecutionContextImpl
implements ExecutionContext {
    private final Map<String, Object> fConfigProperties = new HashMap<String, Object>(5);
    private IProgressMonitor fMonitor;
    private Log fLog;
    private final Map<ISessionData.Entry<Object>, Object> fSessionStorage = new HashMap<ISessionData.Entry<Object>, Object>(5);
    private final ISessionData fSessionData;

    public ExecutionContextImpl() {
        this.fLog = Log.NULL_LOG;
        this.fMonitor = ExecutionContextImpl.createDefaultMonitor();
        this.fSessionData = new Context.SessionDataImpl(this.fSessionStorage);
    }

    @Override
    public Object getConfigProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.fConfigProperties.get(name);
    }

    public void setConfigProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("null config property name");
        }
        this.fConfigProperties.put(name, value);
    }

    @Override
    public Set<String> getConfigPropertyNames() {
        return Collections.unmodifiableSet(this.fConfigProperties.keySet());
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("Non-null logger required");
        }
        this.fLog = log;
    }

    @Override
    public Log getLog() {
        return this.fLog;
    }

    @Override
    public EvaluationMonitor getMonitor() {
        return EvaluationMonitor.EvaluationMonitorWrapper.convert(this.fMonitor);
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    public void setMonitor(EvaluationMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("null monitor");
        }
        this.setProgressMonitor(EvaluationMonitor.EvaluationMonitorWrapper.convert(monitor));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("null monitor");
        }
        this.fMonitor = monitor;
    }

    @Override
    public ISessionData getSessionData() {
        return this.fSessionData;
    }

    @Override
    public Collection<ISessionData.Entry<Object>> getSessionDataEntries() {
        return this.fSessionStorage.keySet();
    }

    private static IProgressMonitor createDefaultMonitor() {
        return new NullProgressMonitor();
    }
}

