/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.DelegatingMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.osgi.util.NLS;

public class ProjectMetamodelProvider
extends DelegatingMetamodelProvider {
    private ResourceSet resSet;
    private List<IMetamodelDesc> metamodels;

    public ProjectMetamodelProvider(IProject project) {
        this(project, MetamodelRegistry.getDefaultMetamodelProvider(), (ResourceSet)new ResourceSetImpl());
    }

    public ProjectMetamodelProvider(IProject project, IMetamodelProvider delegate, ResourceSet resolutionRSet) {
        super(delegate);
        if (resolutionRSet == null) {
            throw new IllegalArgumentException("Null resolution resource set");
        }
        this.resSet = resolutionRSet;
        this.metamodels = new ArrayList<IMetamodelDesc>();
        try {
            MappingContainer mappings = MetamodelURIMappingHelper.loadMappings(project);
            for (URIMapping nextMapping : mappings.getMapping()) {
                URI uri = null;
                IllegalArgumentException error = null;
                try {
                    uri = URI.createURI((String)nextMapping.getTargetURI());
                }
                catch (IllegalArgumentException e) {
                    error = e;
                }
                if (uri != null && nextMapping.getSourceURI() != null) {
                    IMetamodelProvider.DescImpl ePackageDesc = new IMetamodelProvider.DescImpl(uri, this.resSet);
                    EmfMetamodelDesc desc = new EmfMetamodelDesc(ePackageDesc, nextMapping.getSourceURI());
                    this.metamodels.add(desc);
                    continue;
                }
                String message = NLS.bind((String)"Invalid metamodel uri mapping. nsUri:''{0}'' modelUri:''{1}''", (Object)nextMapping.getSourceURI(), (Object)nextMapping.getTargetURI());
                EmfUtilPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.emf.util", message, (Throwable)error));
            }
        }
        catch (IOException e) {
            EmfUtilPlugin.log(e);
        }
    }

    @Override
    protected IMetamodelDesc[] getLocalMetamodels() {
        return this.metamodels.toArray(new IMetamodelDesc[this.metamodels.size()]);
    }
}

