/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromModelWithHookAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.ColorPropertyContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class DiagramEditorContextMenuProvider
extends DiagramContextMenuProvider {
    private static final String DELETE_FROM_GROUP = "deleteFromGroup";
    private static final String FILTER_FORMAT_GROUP = "filterFormatGroup";
    private static final String PLUGIN_MENU_MANAGER_CLASS_NAME = "PluginMenuManager";
    private static final String ARRANGE_GROUP = "myArrangeGroup";
    private IWorkbenchPart part;
    private DeleteFromModelWithHookAction deleteAction;

    public DiagramEditorContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
        super(part, viewer);
        this.part = part;
        this.deleteAction = new DeleteFromModelWithHookAction(part);
        this.deleteAction.init();
    }

    public void dispose() {
        if (this.deleteAction != null) {
            this.deleteAction.dispose();
            this.deleteAction = null;
        }
        super.dispose();
    }

    public void buildContextMenu(IMenuManager menu) {
        this.getViewer().flush();
        try {
            TransactionUtil.getEditingDomain((EObject)((EObject)this.getViewer().getContents().getModel())).runExclusive(() -> {
                IContributionItem copyToImageItem;
                ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)this, this.part);
                menu.remove("deleteFromModelAction");
                this.updateSelectMenu(menu);
                this.updateFormatMenu(menu);
                IMenuManager editMenu = menu.findMenuUsingPath("editMenu");
                IContributionItem find = editMenu.find(DELETE_FROM_GROUP);
                if (find != null) {
                    IContributionItem deleteFromDiagram = menu.find("deleteFromDiagramAction");
                    if (deleteFromDiagram != null) {
                        menu.remove("deleteFromDiagramAction");
                        editMenu.appendToGroup(DELETE_FROM_GROUP, deleteFromDiagram);
                    }
                    editMenu.appendToGroup(DELETE_FROM_GROUP, (IAction)this.deleteAction);
                } else {
                    editMenu.add((IAction)this.deleteAction);
                }
                if (this.clipboardSupportOnlyOnNote() && this.hasViewOfDDiagramElementSelected()) {
                    editMenu.remove(GlobalActionId.CUT);
                    editMenu.remove(GlobalActionId.COPY);
                    editMenu.remove(GlobalActionId.PASTE);
                }
                this.reorganizeLayoutMenu(menu);
                IContributionItem selectHiddenElementsItem = menu.find("selectHiddenElementsAction");
                if (selectHiddenElementsItem != null) {
                    menu.remove(selectHiddenElementsItem);
                    menu.insertAfter(FILTER_FORMAT_GROUP, selectHiddenElementsItem);
                }
                if ((copyToImageItem = menu.find("newCopyToImageAction")) != null) {
                    menu.remove(copyToImageItem);
                    menu.insertAfter(FILTER_FORMAT_GROUP, copyToImageItem);
                }
            });
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean clipboardSupportOnlyOnNote() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_CLIPBOOARD_SUPPORT_ONLY_ON_NOTE.name(), false, null);
    }

    private boolean hasViewOfDDiagramElementSelected() {
        boolean hasViewOfDDiagramElementSelected = false;
        List selectedEditParts = this.getViewer().getSelectedEditParts();
        for (Object object : selectedEditParts) {
            IGraphicalEditPart graphicalEditPart;
            EObject semanticElement;
            if (!(object instanceof IGraphicalEditPart) || !((semanticElement = (graphicalEditPart = (IGraphicalEditPart)object).resolveSemanticElement()) instanceof DDiagramElement)) continue;
            hasViewOfDDiagramElementSelected = true;
            break;
        }
        return hasViewOfDDiagramElementSelected;
    }

    private void updateFormatMenu(IMenuManager menu) {
        IMenuManager manager2 = menu.findMenuUsingPath("formatMenu");
        if (manager2 != null) {
            IContributionItem item = manager2.findUsingPath("fillColorContributionItem");
            if (item != null) {
                manager2.remove("fontColorContributionItem");
                manager2.remove("fillColorContributionItem");
                manager2.remove("lineColorContributionItem");
                manager2.insertAfter("fontDialogAction", (IContributionItem)ColorPropertyContributionItem.createFontColorContributionItem(this.part.getSite().getPage()));
                manager2.insertAfter("fontColorContributionItem", (IContributionItem)ColorPropertyContributionItem.createFillColorContributionItem(this.part.getSite().getPage()));
                manager2.insertAfter("fillColorContributionItem", (IContributionItem)ColorPropertyContributionItem.createLineColorContributionItem(this.part.getSite().getPage()));
            } else {
                item = manager2.findUsingPath("fontDialogAction");
                if (item != null) {
                    manager2.insertAfter("fontDialogAction", (IContributionItem)ColorPropertyContributionItem.createFontColorContributionItem(this.part.getSite().getPage()));
                }
            }
        }
    }

    private void updateSelectMenu(IMenuManager menu) {
        IMenuManager manager2 = menu.findMenuUsingPath("selectMenu");
        if (manager2 != null) {
            manager2.remove(ActionFactory.SELECT_ALL.getId());
            manager2.remove("selectAllShapesAction");
            manager2.remove("selectAllConnectorsAction");
        }
    }

    private void reorganizeLayoutMenu(IMenuManager menu) {
        IMenuManager layoutMenu = menu.findMenuUsingPath("arrangeMenu");
        IMenuManager formatMenu = menu.findMenuUsingPath("formatMenu");
        if (layoutMenu != null) {
            if (PLUGIN_MENU_MANAGER_CLASS_NAME.equals(layoutMenu.getClass().getSimpleName())) {
                IContributionItem layoutChildrenItem = menu.find("layoutChildrenAction");
                IContributionItem arrangeBorderNodesItem = menu.find("arrangeBorderNodesAction");
                IContributionItem movePinnedElementsItem = menu.find("movePinnedElements");
                if (layoutChildrenItem != null) {
                    menu.remove(layoutChildrenItem);
                    layoutMenu.appendToGroup(ARRANGE_GROUP, layoutChildrenItem);
                }
                if (arrangeBorderNodesItem != null) {
                    menu.remove(arrangeBorderNodesItem);
                    layoutMenu.appendToGroup(ARRANGE_GROUP, arrangeBorderNodesItem);
                }
                if (movePinnedElementsItem != null) {
                    menu.remove(movePinnedElementsItem);
                    layoutMenu.appendToGroup(ARRANGE_GROUP, movePinnedElementsItem);
                }
            }
        } else if (formatMenu != null && (layoutMenu = formatMenu.findMenuUsingPath("arrangeMenu")) != null) {
            this.updateArrangeMenuEnableActions(layoutMenu, this.getViewer().getSelection());
            if (PLUGIN_MENU_MANAGER_CLASS_NAME.equals(layoutMenu.getClass().getSimpleName())) {
                formatMenu.remove((IContributionItem)layoutMenu);
                menu.insertAfter(FILTER_FORMAT_GROUP, (IContributionItem)layoutMenu);
            }
        }
    }

    private void updateArrangeMenuEnableActions(IMenuManager arrangeMenu, ISelection selection) {
        IGraphicalEditPart graphicalElement = null;
        if (selection instanceof IStructuredSelection) {
            IGraphicalEditPart diagramEditPart;
            AbstractLayoutEditPartProvider layoutNodeProvider;
            RootEditPart root;
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            while (iterator.hasNext() && graphicalElement == null) {
                Object next = iterator.next();
                if (!(next instanceof IGraphicalEditPart)) continue;
                graphicalElement = (IGraphicalEditPart)next;
            }
            if (graphicalElement != null && (IGraphicalEditPart)(root = graphicalElement.getRoot()).getChildren().iterator().next() != null && (layoutNodeProvider = LayoutService.getProvider(diagramEditPart = (IGraphicalEditPart)root.getChildren().iterator().next()).getLayoutNodeProvider(diagramEditPart)) instanceof ArrangeAllOnlyLayoutProvider) {
                this.disableArrangeSelectionActionFromArrangeMenu(arrangeMenu);
            }
        }
    }

    private void disableArrangeSelectionActionFromArrangeMenu(IMenuManager arrangeMenu) {
        int i = 0;
        while (i < arrangeMenu.getItems().length) {
            ActionContributionItem iContributionItem;
            if (arrangeMenu.getItems()[i] instanceof ActionContributionItem && "arrangeSelectionAction".equals((iContributionItem = (ActionContributionItem)arrangeMenu.getItems()[i]).getId())) {
                iContributionItem.getAction().setEnabled(false);
            }
            ++i;
        }
    }
}

