/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.ActivitySet;
import activity.Claim;
import activity.EventAction;
import activity.Release;
import activity.util.ActivityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.graph.directed.editable.Edge;

public class Event2Resource {
    private Event2Resource() {
    }

    public static void replaceEventsWithClaimRelease(ActivitySet activitySet) {
        Event2Resource.insertClaimReleaseForEvents(activitySet, false);
    }

    public static void surroundEventsWithClaimRelease(ActivitySet activitySet) {
        Event2Resource.insertClaimReleaseForEvents(activitySet, true);
    }

    private static void insertClaimReleaseForEvents(ActivitySet activitySet, boolean keepEvents) {
        Event2Resource.getEvents(activitySet).forEach(event -> Event2Resource.insertClaimReleaseForEvents(event, keepEvents));
    }

    private static Collection<EventAction> getEvents(ActivitySet activitySet) {
        return activitySet.getActivities().stream().flatMap(a -> a.getNodes().stream()).filter(EventAction.class::isInstance).map(EventAction.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void insertClaimReleaseForEvents(EventAction eventAction, boolean keepEvent) {
        Activity activity = (Activity)eventAction.eContainer();
        List eventActions = activity.allNodesInTopologicalOrder().stream().filter(EventAction.class::isInstance).map(EventAction.class::cast).filter(e -> e.getResource().fqn().equals(eventAction.getResource().fqn())).collect(Collectors.toList());
        if (eventActions.indexOf(eventAction) == 0) {
            Event2Resource.insertClaim(eventAction);
        }
        if (eventActions.indexOf(eventAction) == eventActions.size() - 1) {
            Event2Resource.insertRelease(eventAction);
        }
        if (!keepEvent) {
            Event2Resource.shortcutAndRemoveNode(eventAction);
        }
    }

    private static void insertClaim(EventAction eventAction) {
        Activity activity = (Activity)eventAction.eContainer();
        Claim cl = ActivityUtil.addClaim(activity, eventAction.getResource());
        eventAction.getIncomingEdges().forEach(e -> ActivityUtil.addDependency(activity, e.getSourceNode(), cl));
        new ArrayList<Edge>((Collection<Edge>)eventAction.getIncomingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.addDependency(activity, cl, eventAction);
    }

    private static void insertRelease(EventAction eventAction) {
        Activity activity = (Activity)eventAction.eContainer();
        Release rl = ActivityUtil.addRelease(activity, eventAction.getResource());
        eventAction.getOutgoingEdges().forEach(e -> ActivityUtil.addDependency(activity, rl, e.getTargetNode()));
        new ArrayList<Edge>((Collection<Edge>)eventAction.getOutgoingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.addDependency(activity, eventAction, rl);
    }

    private static void shortcutAndRemoveNode(EventAction node) {
        Activity activity = (Activity)node.eContainer();
        for (Edge in : node.getIncomingEdges()) {
            for (Edge out : node.getOutgoingEdges()) {
                ActivityUtil.addDependency(activity, in.getSourceNode(), out.getTargetNode());
            }
        }
        new ArrayList<Edge>((Collection<Edge>)node.getIncomingEdges()).forEach(e -> ActivityUtil.delete(e));
        new ArrayList<Edge>((Collection<Edge>)node.getOutgoingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.delete(node);
    }
}

