/*
 * Decompiled with CFR 0.152.
 */
package distributions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CalculationMode implements Enumerator
{
    MEAN(0, "Mean", "Mean"),
    DISTRIBUTED(1, "Distributed", "Distributed"),
    LINEAIR(2, "Lineair", "Lineair");

    public static final int MEAN_VALUE = 0;
    public static final int DISTRIBUTED_VALUE = 1;
    public static final int LINEAIR_VALUE = 2;
    private static final CalculationMode[] VALUES_ARRAY;
    public static final List<CalculationMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CalculationMode[]{MEAN, DISTRIBUTED, LINEAIR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CalculationMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CalculationMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CalculationMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CalculationMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CalculationMode get(int value) {
        switch (value) {
            case 0: {
                return MEAN;
            }
            case 1: {
                return DISTRIBUTED;
            }
            case 2: {
                return LINEAIR;
            }
        }
        return null;
    }

    private CalculationMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

