/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.ui.quickfix

import dispatching.ActivityDispatching
import dispatching.util.DispatchingUtil
import org.eclipse.lsat.dispatching.teditor.validation.DispatchingValidator
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider
import org.eclipse.xtext.ui.editor.quickfix.Fix
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor
import org.eclipse.xtext.validation.Issue

//import org.eclipse.xtext.ui.editor.quickfix.Fix
//import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor
//import org.eclipse.xtext.validation.Issue
/**
 * Custom quickfixes.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#quickfixes
 */
class DispatchingQuickfixProvider extends DefaultQuickfixProvider {
    

    @Fix(DispatchingValidator::REPLACE_ITEM_FOR_RESOURCE)
    def chooseItem(Issue issue, IssueResolutionAcceptor acceptor) {
        issue.data.forEach [
            val noImage = null
            acceptor.accept(issue, 'Select ' +it, it, noImage) [ context |
                val xtextDocument = context.xtextDocument
                xtextDocument.replace(issue.offset, issue.length, it)
            ]
        ]
    }

    @Fix(DispatchingValidator::REMOVE_ITEM)
    def removeDuplicate(Issue issue, IssueResolutionAcceptor acceptor) {
            val noImage = null
            acceptor.accept(issue, 'Remove' , 'Remove', noImage) [ context |
                val xtextDocument = context.xtextDocument
                xtextDocument.replace(issue.offset, issue.length, "")
            ]
    }

    @Fix(DispatchingValidator::CONVERT_YIELD)
    def convertYield(Issue issue, IssueResolutionAcceptor acceptor) {
       acceptor.accept(issue,"Convert","Convert", "" ,
            [element, context | 
                val ad = element as ActivityDispatching
                DispatchingUtil.convertYield(ad)
            ]
        );
    }
}
