/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.dialog.AbstractListSelectionWizardPage;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;

public class FilterWizard
extends Wizard {
    private final TraceView traceView;
    private final TracePart part;
    private final List<String> allAttributes = new ArrayList<String>();
    private FilterAttributeSelectionWizardPage page1;
    private final Map<String, FilterAttributeValueSelectionWizardPage> idPageMap = new HashMap<String, FilterAttributeValueSelectionWizardPage>();

    public FilterWizard(TracePart part, TraceView view) {
        this.traceView = view;
        this.part = part;
        this.allAttributes.addAll(this.traceView.getAttributeNames(part));
        Collections.sort(this.allAttributes);
        this.setWindowTitle("Filter settings");
        this.setNeedsProgressMonitor(false);
        TrayDialog.setDialogHelpAvailable((boolean)true);
    }

    TracePart getPart() {
        return this.part;
    }

    TraceView getTraceView() {
        return this.traceView;
    }

    List<String> getAllAttributes() {
        return this.allAttributes;
    }

    public void addPages() {
        this.page1 = new FilterAttributeSelectionWizardPage(this);
        this.addPage((IWizardPage)this.page1);
        for (String att : this.allAttributes) {
            FilterAttributeValueSelectionWizardPage valueSelectionPage = new FilterAttributeValueSelectionWizardPage(this, att);
            this.addPage((IWizardPage)valueSelectionPage);
            this.idPageMap.put(att, valueSelectionPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<String> selectedAtts = this.page1.getSelection();
        if (page instanceof FilterAttributeSelectionWizardPage) {
            if (selectedAtts.isEmpty()) {
                return null;
            }
            return (IWizardPage)this.idPageMap.get(selectedAtts.get(0));
        }
        FilterAttributeValueSelectionWizardPage p = (FilterAttributeValueSelectionWizardPage)page;
        String currentAtt = p.getAttribute();
        int index = selectedAtts.indexOf(currentAtt);
        if (index + 1 < selectedAtts.size()) {
            return (IWizardPage)this.idPageMap.get(selectedAtts.get(index + 1));
        }
        return null;
    }

    public boolean canFinish() {
        if (!this.page1.hasSelection()) {
            return false;
        }
        for (String att : this.page1.getSelection()) {
            FilterAttributeValueSelectionWizardPage page = this.idPageMap.get(att);
            if (page.hasSelection()) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        TraceViewConfiguration.DisjunctionFilter filter = new TraceViewConfiguration.DisjunctionFilter();
        for (String att : this.page1.getSelection()) {
            FilterAttributeValueSelectionWizardPage page = this.idPageMap.get(att);
            List<String> includedValues = page.getSelection();
            filter.add(new TraceViewConfiguration.SimpleFilter(att, includedValues));
        }
        this.traceView.getViewConfiguration().addFilter(this.part, filter);
        return true;
    }

    private static final class FilterAttributeSelectionWizardPage
    extends AbstractListSelectionWizardPage {
        public FilterAttributeSelectionWizardPage(FilterWizard wizard) {
            super("FilterAttributeSelectionWizardPage", wizard, AbstractListSelectionWizardPage.SelectionMode.AT_LEAST_ONE);
        }

        @Override
        protected String getPageTitle() {
            return "Attribute filter";
        }

        @Override
        protected String getPageMessage() {
            return "Select the attributes to filter on";
        }

        @Override
        protected Collection<String> getInput() {
            return ((FilterWizard)this.getWizard()).getAllAttributes();
        }
    }

    private static final class FilterAttributeValueSelectionWizardPage
    extends AbstractListSelectionWizardPage {
        private final String att;
        private final List<String> attValues;

        public FilterAttributeValueSelectionWizardPage(FilterWizard wizard, String att) {
            super("FilterAttributeValueSelectionWizardPage", wizard, AbstractListSelectionWizardPage.SelectionMode.AT_LEAST_ONE);
            this.att = att;
            Set<String> values = ((FilterWizard)this.getWizard()).getTraceView().getAllAttributeValuesFor(att, ((FilterWizard)this.getWizard()).getPart());
            this.attValues = new ArrayList<String>();
            this.attValues.addAll(values);
            Collections.sort(this.attValues);
        }

        @Override
        protected String getPageTitle() {
            return "Value selection for: " + this.att;
        }

        @Override
        protected String getPageMessage() {
            return "Select the attribute values to include";
        }

        @Override
        protected Collection<String> getInput() {
            return this.attValues;
        }

        protected String getAttribute() {
            return this.att;
        }
    }
}

