/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelContentViewer;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.ModifiableTrace;
import org.eclipse.trace4cps.ui.view.EclipseDataItemFactory;
import org.eclipse.trace4cps.ui.view.EclipseToolTipGenerator;
import org.eclipse.trace4cps.ui.view.Measurement;
import org.eclipse.trace4cps.ui.view.MeasurementAnnotation;
import org.eclipse.trace4cps.vis.jfree.DataItemFactory;
import org.eclipse.trace4cps.vis.jfree.TracePlotManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.geom.Point2DNumber;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYMeasureWithAnnotations;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeAlign;

public class TraceViewer
extends ChartPanelContentViewer {
    private final TracePlotManager plotMgr;

    public TraceViewer(Composite parent) {
        super(parent);
        this.setPreserveSelection(true);
        this.plotMgr = new TracePlotManager(new ITrace[0]);
        this.plotMgr.setDataItemFactory((DataItemFactory)new EclipseDataItemFactory());
        this.plotMgr.setDelegateToolTipGenerator((XYToolTipGenerator)new EclipseToolTipGenerator(() -> ((TracePlotManager)this.plotMgr).getViewConfig()));
    }

    public TracePlotManager getPlotManager() {
        return this.plotMgr;
    }

    protected void configureChartPanel() {
        super.configureChartPanel();
        XYMeasureWithAnnotations measurer = new XYMeasureWithAnnotations(XYMeasureWithAnnotations.MeasurementAxis.DOMAIN){
            private static final long serialVersionUID = 5406861194841750122L;

            protected void addAnnotation(XYPlot plot, Point2DNumber first, Point2DNumber second, MouseEvent event) {
                Measurement measurement = new Measurement(Math.abs(second.getX() - first.getX()), ((ModifiableTrace)TraceViewer.this.plotMgr.getTraces().get(0)).getTimeUnit());
                plot.addAnnotation((XYAnnotation)new MeasurementAnnotation(measurement.scale(), SwingUtilities.isMiddleMouseButton(event), (Point2D)first, (Point2D)second));
            }
        };
        measurer.addToChartPanel(this.getChartPanel());
        XYPlot xyPlot = new XYPlot();
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setAutoRangeAlign(RangeAlign.LOWER);
        domainAxis.setRangeMinimumSize(1.0E-5);
        xyPlot.setDomainAxis((ValueAxis)domainAxis);
        SectionAxis rangeAxis = new SectionAxis();
        rangeAxis.setRangeMinimumSize(1.0);
        xyPlot.setRangeAxis((ValueAxis)rangeAxis);
        this.plotMgr.initializePlot(xyPlot);
        JFreeChart chart = new JFreeChart(null, null, (Plot)xyPlot, false);
        ChartFactory.getChartTheme().apply(chart);
        this.getChartPanel().setChart(chart);
    }

    protected void refreshChart() {
        this.plotMgr.update(this.getXYPlot());
    }

    public Range getRange() {
        return this.getXYPlot().getDomainAxis().getRange();
    }
}

