/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.internal.tool.command.builders;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OrderedElementCreationTool;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceCreatedEventsFlaggingSiriusCommand;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.tools.internal.command.builders.EdgeCreationCommandBuilder;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class MessageCreationCommandBuilder
extends EdgeCreationCommandBuilder {
    protected EventEnd startingEndPredecessor;
    protected EventEnd finishingEndPredecessor;
    protected DDiagram diagram;

    public MessageCreationCommandBuilder(MessageCreationTool tool, EdgeTarget source, EdgeTarget target, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        super((EdgeCreationDescription)tool, source, target);
        this.startingEndPredecessor = startingEndPredecessor;
        this.finishingEndPredecessor = finishingEndPredecessor;
        if (source instanceof DDiagramElement) {
            this.diagram = ((DDiagramElement)source).getParentDiagram();
        }
    }

    protected DCommand buildCreateEdgeCommandFromTool(EObject semanticSource, EObject semanticTarget) {
        ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.startingEndPredecessor);
        DCommand result = this.createEnclosingCommand();
        HashMap<Object, Object> variables = new HashMap<Object, Object>();
        variables.put(this.tool.getSourceVariable(), semanticSource);
        variables.put(this.tool.getSourceViewVariable(), this.source);
        variables.put(this.tool.getTargetVariable(), semanticTarget);
        variables.put(this.tool.getTargetViewVariable(), this.target);
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            variables.put(orderedElementCreationTool.getStartingEndPredecessor(), this.startingEndPredecessor);
            variables.put(orderedElementCreationTool.getFinishingEndPredecessor(), this.finishingEndPredecessor);
        }
        result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)this.source), (UICallBack)new EMFCommandFactoryUI()));
        TaskHelper taskHelper = new TaskHelper(modelAccessor, (UICallBack)new EMFCommandFactoryUI());
        result.getTasks().add(taskHelper.buildTaskFromModelOperation((DRepresentation)this.diagram, (EObject)this.source, this.tool.getInitialOperation().getFirstModelOperations()));
        return result;
    }

    protected DCommand createEnclosingCommand() {
        return new SequenceCreatedEventsFlaggingSiriusCommand(this.editingDomain, this.getEnclosingCommandLabel(), this.diagram, Message.viewpointElementPredicate());
    }

    protected boolean evaluatePrecondition(IInterpreter interpreter, EObject semanticContainer, String precondition) {
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.setVariable(orderedElementCreationTool.getStartingEndPredecessor().getName(), (Object)this.startingEndPredecessor);
            interpreter.setVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName(), (Object)this.finishingEndPredecessor);
        }
        boolean result = super.evaluatePrecondition(interpreter, semanticContainer, precondition);
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.unSetVariable(orderedElementCreationTool.getStartingEndPredecessor().getName());
            interpreter.unSetVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName());
        }
        return result;
    }

    protected Option<DDiagram> getDDiagram() {
        return Options.newSome((Object)this.diagram);
    }
}

