/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.lsat.common.util.AppendableIterator;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.IteratorUtil;
import org.eclipse.lsat.common.util.UniqueIterator;

public class ClosureIterator<E>
implements BranchIterator<E> {
    private final AppendableIterator<E> closureCandidates;
    private final UniqueIterator<E> closureResults;
    private boolean canPrune = false;

    public ClosureIterator(Iterator<? extends E> source, boolean includeSource, Function<E, Iterator<? extends E>> closureFunctor) {
        if (includeSource) {
            this.closureCandidates = new AppendableIterator();
            this.closureResults = new UniqueIterator(IteratorUtil.join(source, IteratorUtil.flatMap(this.closureCandidates, closureFunctor)));
        } else {
            this.closureCandidates = new AppendableIterator<E>(source);
            this.closureResults = new UniqueIterator<E>(IteratorUtil.flatMap(this.closureCandidates, closureFunctor));
        }
    }

    @Override
    public boolean hasNext() {
        this.canPrune = false;
        return this.closureResults.hasNext();
    }

    @Override
    public E next() {
        Object next = this.closureResults.next();
        this.closureCandidates.append(next);
        this.canPrune = true;
        return next;
    }

    @Override
    public void prune() {
        if (!this.canPrune) {
            throw new IllegalStateException("Prune is not allowed");
        }
        this.closureCandidates.undoAppend();
        this.canPrune = false;
    }
}

