/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.lsat.timing.Activator;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MotionCalculatorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public MotionCalculatorPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.lsat.timing.calculator", "Motion calculator", 1, this.getLabelsAndValues(), this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.lsat.timing.view.debug", "Show debug information in chart view", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Configures the motion calculator to use for this workspace.");
    }

    private String[][] getLabelsAndValues() {
        List<MotionCalculatorExtension> motionCalculators = MotionCalculatorExtension.getAvailableMotionCalculators();
        String[][] labelsAndValues = new String[motionCalculators.size()][2];
        int i = 0;
        while (i < labelsAndValues.length) {
            labelsAndValues[i][0] = motionCalculators.get(i).getName();
            labelsAndValues[i][1] = motionCalculators.get(i).getId();
            ++i;
        }
        return (String[][])Arrays.stream(labelsAndValues).sorted((a, b) -> a[0].compareTo(b[0])).toArray(n -> new String[n][]);
    }
}

