/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.label;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class StylerFactory {
    public StyledString.Styler createStyler(String foregroundColorName, String backgroundColorName) {
        return new DefaultFontStyler(null, foregroundColorName, backgroundColorName);
    }

    public StyledString.Styler createStyler(FontDescriptor fontDescriptor, String foregroundColorName, String backgroundColorName) {
        return new DefaultFontStyler(fontDescriptor, foregroundColorName, backgroundColorName);
    }

    public StyledString.Styler createXtextStyleAdapterStyler(TextStyle xtextStyle) {
        return new XtextStyleAdapterStyler(xtextStyle);
    }

    public StyledString createFromXtextStyle(String text, TextStyle xtextStyle) {
        return new StyledString(text, (StyledString.Styler)new XtextStyleAdapterStyler(xtextStyle));
    }

    protected static class DefaultFontStyler
    extends StyledString.Styler {
        private final FontDescriptor fontDescriptor;
        private final String foregroundColorName;
        private final String backgroundColorName;

        public DefaultFontStyler(FontDescriptor fontDescriptor, String foregroundColorName, String backgroundColorName) {
            this.fontDescriptor = fontDescriptor;
            this.foregroundColorName = foregroundColorName;
            this.backgroundColorName = backgroundColorName;
        }

        public void applyStyles(org.eclipse.swt.graphics.TextStyle textStyle) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (this.fontDescriptor != null) {
                textStyle.font = this.fontDescriptor.createFont((Device)Display.getCurrent());
            }
            if (this.foregroundColorName != null) {
                textStyle.foreground = colorRegistry.get(this.foregroundColorName);
            }
            if (this.backgroundColorName != null) {
                textStyle.background = colorRegistry.get(this.backgroundColorName);
            }
        }
    }

    protected static class XtextStyleAdapterStyler
    extends StyledString.Styler {
        private TextStyle xtextTextStyle;

        public XtextStyleAdapterStyler(TextStyle textStyle) {
            this.xtextTextStyle = textStyle;
        }

        public void applyStyles(org.eclipse.swt.graphics.TextStyle textStyle) {
            textStyle.strikeout = (this.xtextTextStyle.getStyle() & 0x20000000) != 0;
            boolean bl = textStyle.underline = (this.xtextTextStyle.getStyle() & 0x40000000) != 0;
            if (this.xtextTextStyle.getFontData() == null && this.xtextTextStyle.getStyle() != 0) {
                FontData fontData = new FontData();
                fontData.setStyle(this.xtextTextStyle.getStyle());
                this.xtextTextStyle.setFontData(fontData);
            }
            textStyle.font = EditorUtils.fontFromFontData(this.xtextTextStyle.getFontData());
            if (this.xtextTextStyle.getBackgroundColor() != null) {
                textStyle.background = EditorUtils.colorFromRGB(this.xtextTextStyle.getBackgroundColor());
            }
            textStyle.foreground = EditorUtils.colorFromRGB(this.xtextTextStyle.getColor());
        }
    }
}

