/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.rename.LSPCreateParticipant;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.FileCreate;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CreateArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LSPCreateParticipantTest
extends AbstractTestWithProject {
    LSPCreateParticipantTest() {
    }

    @BeforeEach
    void setupCaps() {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            fileOps.setWillCreate(new FileOperationOptions());
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
    }

    @Test
    void fileCreateSendsWillCreate() throws Exception {
        IFile starter = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(starter);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFile toCreate = this.project.getFile("toCreate.lspt");
        URI uri = LSPEclipseUtils.toUri((IResource)toCreate);
        Assertions.assertNotNull((Object)uri);
        TestableCreateParticipant participant = new TestableCreateParticipant();
        participant.setArgs(new CreateArguments());
        Assertions.assertTrue((boolean)participant.initialize(toCreate));
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), new CheckConditionsContext());
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillCreate());
        Assertions.assertEquals((int)1, (int)ws.getLastWillCreate().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileCreate)ws.getLastWillCreate().getFiles().get(0)).getUri());
    }

    @Test
    void folderCreateSendsWillCreate() throws Exception {
        IFile starter = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(starter);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFolder toCreate = this.project.getFolder("toCreateFolder");
        URI uri = LSPEclipseUtils.toUri((IResource)toCreate);
        Assertions.assertNotNull((Object)uri);
        TestableCreateParticipant participant = new TestableCreateParticipant();
        participant.setArgs(new CreateArguments());
        Assertions.assertTrue((boolean)participant.initialize(toCreate));
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), new CheckConditionsContext());
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillCreate());
        Assertions.assertEquals((int)1, (int)ws.getLastWillCreate().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileCreate)ws.getLastWillCreate().getFiles().get(0)).getUri());
    }

    static class TestableCreateParticipant
    extends LSPCreateParticipant {
        private CreateArguments args;

        TestableCreateParticipant() {
        }

        void setArgs(CreateArguments args) {
            this.args = args;
        }

        public boolean initialize(Object element) {
            return super.initialize(element);
        }

        public CreateArguments getArguments() {
            return this.args;
        }
    }
}

