/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.lsp4e.internal.StyleUtil;
import org.eclipse.lsp4e.operations.semanticTokens.AbstractSemanticTokensDataStreamProcessor;
import org.eclipse.lsp4j.Position;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;

public class SemanticTokensDataStreamProcessor
extends AbstractSemanticTokensDataStreamProcessor<IToken, StyleRange> {
    public SemanticTokensDataStreamProcessor(Function<String, @Nullable IToken> tokenTypeMapper, Function<Position, Integer> offsetMapper) {
        super(offsetMapper, tokenTypeMapper);
    }

    @Override
    protected @Nullable StyleRange createTokenData(@Nullable IToken tokenType, int offset, int length, List<String> tokenModifiers) {
        StyleRange styleRange = this.getStyleRange(offset, length, this.textAttribute(tokenType));
        if (tokenModifiers.stream().anyMatch(x -> x.equals("deprecated"))) {
            if (styleRange == null) {
                styleRange = new StyleRange();
                styleRange.start = offset;
                styleRange.length = length;
            }
            StyleUtil.DEPRECATE.applyStyles((TextStyle)styleRange);
        }
        return styleRange;
    }

    private @Nullable TextAttribute textAttribute(@Nullable IToken tokenType) {
        Object data;
        if (tokenType != null && (data = tokenType.getData()) instanceof TextAttribute) {
            TextAttribute textAttribute = (TextAttribute)data;
            return textAttribute;
        }
        return null;
    }

    private @Nullable StyleRange getStyleRange(int offset, int length, @Nullable TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            styleRange.font = attr.getFont();
            return styleRange;
        }
        return null;
    }
}

