/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.rename;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class RenameTest
extends AbstractTestWithProject {
    @Test
    public void testRenameHandlerEnablement() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
        editor.selectAndReveal(1, 0);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        TestUtils.waitForAndAssertCondition(2000, () -> ((Command)command).isEnabled());
        Assertions.assertTrue((boolean)command.isHandled());
    }

    @Test
    public void testAsyncRenameHandlerEnablement() throws Exception {
        int delay = 4000;
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(4000L);
        try {
            IFile file = TestUtils.createUniqueTestFile(this.project, "old");
            ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
            Assertions.assertFalse((boolean)command.isEnabled());
            editor.selectAndReveal(1, 0);
            TestUtils.waitForAndAssertCondition(8000, () -> ((Command)command).isEnabled());
            Assertions.assertTrue((boolean)command.isHandled());
        }
        finally {
            MockLanguageServer.INSTANCE.setTimeToProceedQueries(0L);
        }
    }

    @Test
    public void testRenameRefactoring() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        processor.setNewName("new");
        try {
            ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)"new", (Object)document.get());
    }

    @Test
    public void testPrepareRenameRefactoring() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        processor.setNewName("new");
        try {
            ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)"new", (Object)document.get());
    }

    @Test
    public void testPrepareRenameRefactoringError() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        MockLanguageServer.INSTANCE.getTextDocumentService().setPrepareRenameResult(null);
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        processor.setNewName("new");
        try {
            ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            RefactoringStatus status = processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            Assertions.assertEquals((int)4, (int)status.getSeverity());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRenameRefactoringExternalFile(@TempDir Path tempDir) throws Exception {
        Path file = Files.createFile(tempDir.resolve("testPerformOperationExternalFile.lspt"), new FileAttribute[0]);
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(file.toUri()));
        IFileStore store = EFS.getStore((URI)file.toUri());
        ITextFileBufferManager manager = ITextFileBufferManager.DEFAULT;
        try {
            manager.connectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
            IDocument document = ((ITextFileBuffer)manager.getFileStoreFileBuffer(store)).getDocument();
            document.set("old");
            LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
            processor.setNewName("new");
            try {
                ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            Assertions.assertEquals((Object)"new", (Object)document.get());
        }
        finally {
            manager.disconnectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testRenameChangeAlsoExternalFile(@TempDir Path tempDir) throws Exception {
        IFile workspaceFile = TestUtils.createUniqueTestFile(this.project, "old");
        Path externalFile = Files.writeString(tempDir.resolve("testRenameChangeAlsoExternalFile.lspt"), (CharSequence)"old", new OpenOption[0]);
        HashMap<String, List<TextEdit>> edits = new HashMap<String, List<TextEdit>>(2, 1.0f);
        edits.put(LSPEclipseUtils.toUri((IResource)workspaceFile).toString(), List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new")));
        edits.put(LSPEclipseUtils.toUri((File)externalFile.toFile()).toString(), List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new")));
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(new WorkspaceEdit(edits));
        IDocument document = LSPEclipseUtils.getDocument((IResource)workspaceFile);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        processor.setNewName("new");
        try {
            ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            processorBasedRefactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            processorBasedRefactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)"new", (Object)document.get());
        Assertions.assertEquals((Object)"new", (Object)Files.readString(externalFile));
    }

    @Test
    public void testRenameHandlerExecution() throws Exception {
        Display display;
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").putBoolean("org.eclipse.lsp4e.inlineRename", false);
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(file);
        editor.selectAndReveal(1, 0);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        Assertions.assertTrue((command.isEnabled() && command.isHandled() ? 1 : 0) != 0);
        Event e = new Event();
        e.widget = (Widget)editor.getAdapter(Control.class);
        Shell ideShell = editor.getSite().getShell();
        e.display = display = ideShell.getDisplay();
        AtomicBoolean renameDialogOkPressed = new AtomicBoolean();
        Listener pressOKonRenameDialogPaint = event -> {
            Composite composite;
            Shell shell2;
            if (renameDialogOkPressed.get()) {
                return;
            }
            if (event.widget instanceof Composite && (shell2 = (composite = (Composite)event.widget).getShell()) != ideShell && "Rename".equals(shell2.getText())) {
                event.widget.getDisplay().asyncExec(() -> this.pressOk(shell2));
                renameDialogOkPressed.set(true);
            }
        };
        try {
            display.addFilter(9, pressOKonRenameDialogPaint);
            ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, e);
            command.executeWithChecks(executionEvent);
            TestUtils.waitForAndAssertCondition("Rename dialog not shown", 3000, display, renameDialogOkPressed::get);
            IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
            TestUtils.waitForAndAssertCondition("document not modified, rename not applied", 3000, display, () -> "new".equals(document.get()));
        }
        finally {
            ideShell.getDisplay().removeFilter(9, pressOKonRenameDialogPaint);
        }
    }

    @Test
    public void testPlaceholderUsingPlaceholderFromPrepareRenameResult() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        try {
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)"placeholder", (Object)processor.getPlaceholder());
    }

    @Test
    public void testPlaceholderUsingRangeFromPrepareRenameResult() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "old");
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(RenameTest.createSimpleMockRenameEdit(LSPEclipseUtils.toUri((IResource)file)));
        Range range = new Range(new Position(0, 1), new Position(0, 3));
        MockLanguageServer.INSTANCE.getTextDocumentService().setPrepareRenameResult(Either.forLeft((Object)range));
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        LSPRenameProcessor processor = new LSPRenameProcessor(document, 0);
        try {
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)"ld", (Object)processor.getPlaceholder());
    }

    private void pressOk(Shell dialogShell) {
        try {
            Dialog dialog = (Dialog)dialogShell.getData();
            Method okPressedMethod = Dialog.class.getDeclaredMethod("okPressed", new Class[0]);
            okPressedMethod.setAccessible(true);
            okPressedMethod.invoke((Object)dialog, new Object[0]);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static WorkspaceEdit createSimpleMockRenameEdit(URI fileUri) {
        WorkspaceEdit res = new WorkspaceEdit();
        File f = new File(fileUri);
        res.setChanges(Collections.singletonMap(LSPEclipseUtils.toUri((File)f).toString(), List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new"))));
        return res;
    }
}

