/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jsonp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.ASTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.jsonp.ErrorCode;

public class JsonpDiagnosticParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        List<MethodInvocation> allMethodInvocations = ASTUtils.getMethodInvocations(unit);
        List createPointerInvocations = allMethodInvocations.stream().filter(mi -> {
            try {
                return this.isMatchedJsonCreatePointer(unit, (MethodInvocation)mi);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }).collect(Collectors.toList());
        for (MethodInvocation m : createPointerInvocations) {
            Expression arg = (Expression)m.arguments().get(0);
            if (!this.isInvalidArgument(arg)) continue;
            try {
                String msg = Messages.getMessage("CreatePointerErrorMessage", new Object[0]);
                Range range = JDTUtils.toRange((IOpenable)unit, (int)arg.getStartPosition(), (int)arg.getLength());
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-jsonp", ErrorCode.InvalidJsonCreatePointerTarget, DiagnosticSeverity.Error));
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
        return diagnostics;
    }

    private boolean isInvalidArgument(Expression arg) {
        String argValue;
        return arg instanceof StringLiteral && !(argValue = ((StringLiteral)arg).getLiteralValue()).isEmpty() && !argValue.matches("^(\\/[^\\/]+)+$");
    }

    private boolean isMatchedJsonCreatePointer(ICompilationUnit unit, MethodInvocation mi) throws JavaModelException {
        Expression ex;
        String qualifier;
        if (mi.arguments().size() == 1 && "createPointer".equals(mi.getName().getIdentifier()) && mi.getExpression() != null && "jakarta.json.Json".endsWith(qualifier = (ex = mi.getExpression()).toString())) {
            if (DiagnosticUtils.isImportedJavaElement(unit, "jakarta.json.Json")) {
                return true;
            }
            if ("jakarta.json.Json".equals(qualifier)) {
                ITypeBinding itb = ex.resolveTypeBinding();
                return itb != null && qualifier.equals(itb.getQualifiedName());
            }
        }
        return false;
    }
}

