/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.Test;

public class ResourceAnnotationTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = ResourceAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/ResourceAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 0, 22, "The @Resource annotation must define the attribute 'type'.", DiagnosticSeverity.Error, "jakarta-annotations", "MissingResourceTypeAttribute");
        Diagnostic d2 = JakartaForJavaAssert.d(39, 0, 30, "The @Resource annotation must define the attribute 'name'.", DiagnosticSeverity.Error, "jakarta-annotations", "MissingResourceNameAttribute");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(22, 0, 22, 22, "@Resource(name = \"aa\", type = \"\")");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Insert 'type' attribute to @Resource", d1, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te1 = JakartaForJavaAssert.te(39, 0, 39, 30, "@Resource(type = Object.class, name = \"\")");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Insert 'name' attribute to @Resource", d2, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca1);
    }
}

