/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.di;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.Test;

public class DependencyInjectionTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void DependencyInjectionDiagnostics() throws Exception {
        IJavaProject javaProject = DependencyInjectionTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/GreetingServlet.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(29, 27, 35, "The @Inject annotation must not define a final field.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnFinalField");
        Diagnostic d2 = JakartaForJavaAssert.d(44, 25, 39, "The @Inject annotation must not define an abstract method.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnAbstractMethod");
        Diagnostic d3 = JakartaForJavaAssert.d(38, 22, 33, "The @Inject annotation must not define a final method.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnFinalMethod");
        Diagnostic d4 = JakartaForJavaAssert.d(54, 23, 36, "The @Inject annotation must not define a generic method.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnGenericMethod");
        Diagnostic d5 = JakartaForJavaAssert.d(48, 23, 35, "The @Inject annotation must not define a static method.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnStaticMethod");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4, d5);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(28, 4, 29, 4, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d1, te);
        TextEdit te1 = JakartaForJavaAssert.te(29, 11, 29, 17, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'final' modifier", d1, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        te = JakartaForJavaAssert.te(43, 4, 44, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d2, te);
        te1 = JakartaForJavaAssert.te(44, 10, 44, 19, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'abstract' modifier", d2, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        te = JakartaForJavaAssert.te(37, 4, 38, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d3, te);
        te1 = JakartaForJavaAssert.te(38, 10, 38, 16, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'final' modifier", d3, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d4);
        te = JakartaForJavaAssert.te(53, 4, 54, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d4, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d5);
        te = JakartaForJavaAssert.te(47, 4, 48, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d5, te);
        te1 = JakartaForJavaAssert.te(48, 10, 48, 17, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d5, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
    }
}

