/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.persistence;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.persistence.ErrorCode;

public class PersistenceEntityDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                Range range;
                Range range2;
                IType type = iTypeArray[n2];
                IAnnotation[] allAnnotations = type.getAnnotations();
                IAnnotation EntityAnnotation = null;
                IAnnotation[] iAnnotationArray = allAnnotations;
                int n3 = allAnnotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation annotation = iAnnotationArray[n4];
                    if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.persistence.Entity")) {
                        EntityAnnotation = annotation;
                    }
                    ++n4;
                }
                if (EntityAnnotation == null) break block14;
                boolean hasPublicOrProtectedNoArgConstructor = false;
                boolean hasArgConstructor = false;
                boolean isEntityClassFinal = false;
                IMethod[] iMethodArray = type.getMethods();
                int n5 = iMethodArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    block17: {
                        IMethod method;
                        block15: {
                            block16: {
                                method = iMethodArray[n6];
                                if (!DiagnosticUtils.isConstructorMethod(method)) break block15;
                                if (method.getNumberOfParameters() <= 0) break block16;
                                hasArgConstructor = true;
                                break block17;
                            }
                            if (method.getFlags() != 1 && method.getFlags() != 4) break block17;
                            hasPublicOrProtectedNoArgConstructor = true;
                        }
                        if (this.isFinal(method.getFlags())) {
                            range2 = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("EntityNoFinalMethods", new Object[0]), range2, "jakarta-persistence", method.getElementType(), ErrorCode.InvalidFinalMethodInEntityAnnotatedClass, DiagnosticSeverity.Error));
                        }
                    }
                    ++n6;
                }
                iMethodArray = type.getFields();
                n5 = iMethodArray.length;
                n6 = 0;
                while (n6 < n5) {
                    IMethod field = iMethodArray[n6];
                    if (!this.isStatic(field.getFlags()) && this.isFinal(field.getFlags())) {
                        range2 = PositionUtils.toNameRange((IField)field, context.getUtils());
                        diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("EntityNoFinalVariables", new Object[0]), range2, "jakarta-persistence", field.getElementType(), ErrorCode.InvalidPersistentFieldInEntityAnnotatedClass, DiagnosticSeverity.Error));
                    }
                    ++n6;
                }
                if (this.isFinal(type.getFlags())) {
                    isEntityClassFinal = true;
                }
                if (!hasPublicOrProtectedNoArgConstructor && hasArgConstructor) {
                    range = PositionUtils.toNameRange(type, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("EntityNoArgConstructor", new Object[0]), range, "jakarta-persistence", null, ErrorCode.InvalidConstructorInEntityAnnotatedClass, DiagnosticSeverity.Error));
                }
                if (isEntityClassFinal) {
                    range = PositionUtils.toNameRange(type, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("EntityNoFinalClass", new Object[0]), range, "jakarta-persistence", type.getElementType(), ErrorCode.InvalidFinalModifierOnEntityAnnotatedClass, DiagnosticSeverity.Error));
                }
            }
            ++n2;
        }
        return diagnostics;
    }

    private boolean isStatic(int flag) {
        Integer isPublicStatic = flag - 1;
        Integer isPrivateStatic = flag - 2;
        Integer isFinalStatic = flag - 16;
        Integer isProtectedStatic = flag - 4;
        Integer isStatic = flag;
        return isPublicStatic.equals(8) || isPrivateStatic.equals(8) || isStatic.equals(8) || isFinalStatic.equals(8) || isProtectedStatic.equals(8);
    }

    private boolean isFinal(int flag) {
        Integer isPublicFinal = flag - 1;
        Integer isPrivateFinal = flag - 2;
        Integer isProtectedFinal = flag - 4;
        Integer isFinal = flag;
        return isPublicFinal.equals(16) || isPrivateFinal.equals(16) || isProtectedFinal.equals(16) || isFinal.equals(16);
    }
}

