/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.utils;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JDTTypeUtils {
    private static final List<String> NUMBER_TYPES = Arrays.asList("short", "int", "long", "double", "float");

    public static IType findType(IJavaProject project, String name) {
        try {
            IType type = project.findType(name, (IProgressMonitor)new NullProgressMonitor());
            if (type != null && type.exists()) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {}
        try {
            return project.findType(name);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getResolvedTypeName(IJavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 14: {
                return JDTTypeUtils.getResolvedTypeName((ILocalVariable)javaElement);
            }
            case 8: {
                return JDTTypeUtils.getResolvedTypeName((IField)javaElement);
            }
        }
        return null;
    }

    public static String getResolvedTypeName(ILocalVariable localVar) {
        try {
            String signature = localVar.getTypeSignature().replace("/", ".");
            IType primaryType = localVar.getTypeRoot().findPrimaryType();
            return JavaModelUtil.getResolvedTypeName((String)signature, (IType)primaryType, (char)'$');
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getResolvedTypeName(IField field) {
        try {
            String signature = field.getTypeSignature();
            IType primaryType = field.getTypeRoot().findPrimaryType();
            return JavaModelUtil.getResolvedTypeName((String)signature, (IType)primaryType, (char)'$');
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getResolvedResultTypeName(IMethod method) {
        try {
            String signature = method.getReturnType();
            IType primaryType = method.getTypeRoot().findPrimaryType();
            return JavaModelUtil.getResolvedTypeName((String)signature, (IType)primaryType, (char)'$');
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getDefaultValue(IMethod method) {
        IMemberValuePair defaultValue;
        block8: {
            try {
                defaultValue = method.getDefaultValue();
                if (defaultValue != null && defaultValue.getValue() != null) break block8;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        switch (defaultValue.getValueKind()) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                String value = defaultValue.getValue().toString();
                return value.isEmpty() ? null : value;
            }
            case 12: 
            case 13: {
                String qualifiedName = defaultValue.getValue().toString();
                int index = qualifiedName.lastIndexOf(46);
                return index != -1 ? qualifiedName.substring(index + 1, qualifiedName.length()) : qualifiedName;
            }
            case 14: {
                return null;
            }
        }
        return null;
    }

    public static String getPropertyType(IType type, String typeName) {
        return type != null ? type.getFullyQualifiedName('$') : typeName;
    }

    public static boolean isBinary(IJavaElement javaElement) {
        if (javaElement instanceof IMember) {
            return ((IMember)javaElement).isBinary();
        }
        if (javaElement instanceof ILocalVariable) {
            return JDTTypeUtils.isBinary((IJavaElement)((ILocalVariable)javaElement).getDeclaringMember());
        }
        return false;
    }

    public static String getSourceType(IJavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 14: {
                return JDTTypeUtils.getSourceType((ILocalVariable)javaElement);
            }
            case 8: {
                return JDTTypeUtils.getSourceType((IMember)((IField)javaElement));
            }
            case 9: {
                return JDTTypeUtils.getSourceType((IMember)((IMethod)javaElement));
            }
            case 7: {
                return JDTTypeUtils.getSourceType((IType)javaElement);
            }
        }
        return null;
    }

    public static String getSourceType(ILocalVariable member) {
        return JDTTypeUtils.getSourceType(member.getDeclaringMember());
    }

    public static String getSourceType(IType type) {
        return JDTTypeUtils.getPropertyType(type, null);
    }

    public static String getSourceType(IMember member) {
        return JDTTypeUtils.getPropertyType(member.getDeclaringType(), null);
    }

    public static String getSourceField(IJavaElement field) {
        return field.getElementName();
    }

    public static String getSourceMethod(IMethod method) throws JavaModelException {
        return method.getElementName() + method.getSignature();
    }

    public static boolean isOptional(String fieldTypeName) {
        return fieldTypeName.startsWith("java.util.Optional");
    }

    public static String getOptionalTypeParameter(String typeName) {
        if (!JDTTypeUtils.isOptional(typeName)) {
            return null;
        }
        int start = typeName.indexOf(60);
        if (start == -1) {
            return null;
        }
        int end = typeName.lastIndexOf(62);
        return typeName.substring(start + 1, end);
    }

    public static IType getEnclosedType(IType type, String typeName, IJavaProject javaProject) throws JavaModelException {
        String enclosedType = typeName;
        if (type == null && (enclosedType = JDTTypeUtils.getOptionalTypeParameter(typeName)) != null) {
            type = JDTTypeUtils.findType(javaProject, enclosedType);
        }
        return type;
    }

    public static String[] getRawTypeParameters(String fieldTypeName) {
        int start = fieldTypeName.indexOf("<") + 1;
        int end = fieldTypeName.lastIndexOf(">");
        String keyValue = fieldTypeName.substring(start, end);
        int index = keyValue.indexOf(44);
        return new String[]{keyValue.substring(0, index), keyValue.substring(index + 1, keyValue.length())};
    }

    public static boolean isPrimitiveType(String valueClass) {
        return valueClass.equals("java.lang.String") || valueClass.equals("java.lang.Boolean") || valueClass.equals("java.lang.Integer") || valueClass.equals("java.lang.Long") || valueClass.equals("java.lang.Double") || valueClass.equals("java.lang.Float");
    }

    public static boolean isMap(String mapValueClass) {
        return mapValueClass.startsWith("java.util.Map");
    }

    public static boolean isList(String valueClass) {
        return valueClass.startsWith("java.util.List");
    }

    public static boolean isNumber(String valueClass) {
        return NUMBER_TYPES.contains(valueClass);
    }

    public static boolean isPrimitiveBoolean(String valueClass) {
        return valueClass.equals("boolean");
    }

    public static IJarEntryResource findPropertiesResource(IPackageFragmentRoot packageRoot, String propertiesFileName) throws JavaModelException {
        Object[] resources = packageRoot.getNonJavaResources();
        if (resources != null) {
            Object[] objectArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IJarEntryResource res;
                Object object = objectArray[n2];
                if (object instanceof IJarEntryResource && "META-INF".equals((res = (IJarEntryResource)object).getName())) {
                    IJarEntryResource[] children = res.getChildren();
                    if (children != null) {
                        IJarEntryResource[] iJarEntryResourceArray = children;
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJarEntryResource r = iJarEntryResourceArray[n4];
                            if (propertiesFileName.equals(r.getName())) {
                                return r;
                            }
                            ++n4;
                        }
                    }
                    return null;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isSimpleFieldType(IType type, String typeName) throws JavaModelException {
        return type == null || JDTTypeUtils.isPrimitiveType(typeName) || JDTTypeUtils.isList(typeName) || JDTTypeUtils.isMap(typeName) || JDTTypeUtils.isOptional(typeName) || type != null && type.isEnum();
    }

    public static boolean overlaps(ISourceRange typeRange, ISourceRange methodRange) {
        if (typeRange == null || methodRange == null) {
            return false;
        }
        return methodRange.getOffset() < typeRange.getOffset() || methodRange.getOffset() >= typeRange.getOffset() && methodRange.getOffset() <= typeRange.getOffset() + typeRange.getLength();
    }

    public static boolean isVoidReturnType(IMethod method) throws JavaModelException {
        return "V".equals(method.getReturnType());
    }
}

