/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.inlayhint;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintSettings;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterValidator;
import org.eclipse.lsp4mp.jdt.core.java.AbtractJavaContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;

public class JavaInlayHintsContext
extends AbtractJavaContext {
    private static final Logger LOGGER = Logger.getLogger(JavaInlayHintsContext.class.getName());
    private final MicroProfileJavaInlayHintParams params;
    private final List<InlayHint> inlayHints;
    private MicroProfileJavaInlayHintSettings settings;

    public JavaInlayHintsContext(String uri, ITypeRoot typeRoot, IJDTUtils utils, MicroProfileJavaInlayHintParams params, List<InlayHint> inlayHints) {
        super(uri, typeRoot, utils);
        this.params = params;
        this.inlayHints = inlayHints;
        this.settings = params.getSettings() == null ? new MicroProfileJavaInlayHintSettings(ExecutionMode.SAFE) : params.getSettings();
    }

    public MicroProfileJavaInlayHintSettings getSettings() {
        return this.settings;
    }

    public MicroProfileJavaInlayHintParams getParams() {
        return this.params;
    }

    public InlayHint addInlayHint(String label, int offset, int length) {
        try {
            ITypeRoot openable = this.getTypeRoot();
            Range range = this.getUtils().toRange((IOpenable)openable, offset, length);
            InlayHint inlayHint = new InlayHint();
            inlayHint.setLabel(label);
            inlayHint.setKind(InlayHintKind.Type);
            inlayHint.setPosition(range.getStart());
            return this.addInlayHint(inlayHint);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while creating inlay hint '" + label + "'.", e);
            return null;
        }
    }

    public InlayHint addInlayHint(InlayHint inlayHint) {
        this.inlayHints.add(inlayHint);
        return inlayHint;
    }

    public void addConverterInlayHint(ITypeBinding fieldBinding, ASTNode node) {
        String converter;
        MicroProfileProjectRuntime projectRuntime = super.getProjectRuntime();
        if (projectRuntime == null) {
            return;
        }
        ExecutionMode preferredMode = this.getSettings().getMode();
        EnumConstantsProvider.SimpleEnumConstantsProvider provider = new EnumConstantsProvider.SimpleEnumConstantsProvider();
        String fqn = JavaInlayHintsContext.toQualifiedTypeString(fieldBinding, provider);
        ConverterValidator converterValidator = projectRuntime.findConverterValidator(fqn, provider, preferredMode);
        String string = converter = converterValidator.getConverterSimpleClassName() != null ? converterValidator.getConverterSimpleClassName() : null;
        if (converter != null) {
            this.addInlayHint(converter + " ", node.getStartPosition(), node.getLength());
        }
    }
}

