/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql;

import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.graphql.DefaultValue;
import org.eclipse.microprofile.graphql.Query;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultValueTest {
    @Test
    public void testDefaultValueAnnotationOnCharacterParameter() throws Exception {
        DefaultValue defaultValue = (DefaultValue)Character.class.getDeclaredMethod("getFriendsOf", Character.class).getParameterAnnotations()[0][0];
        Assert.assertEquals((String)defaultValue.value(), (String)"Han Solo");
    }

    private static class Character {
        private String name;

        public Character(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Query(value="friendsOf")
        public List<Character> getFriendsOf(@DefaultValue(value="Han Solo") Character character) {
            if (character.getName().equals("Han Solo")) {
                return Collections.singletonList(new Character("Chewbacca"));
            }
            return Collections.emptyList();
        }
    }
}

