/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.subscribers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class SubscriberBean {
    private Map<String, List<String>> collector = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> EXPECTED = Arrays.asList("1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "10", "10");
    private static Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();

    private static void increment(String counter) {
        counters.computeIfAbsent(counter, x -> new AtomicInteger(0)).incrementAndGet();
    }

    @Outgoing(value="subscriber-message")
    public Publisher<Message<String>> sourceForSubscriberMessage() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="subscriber-message")
    public Subscriber<Message<String>> subscriberOfMessages() {
        SubscriberBean.increment("subscriber-message");
        return ReactiveStreams.builder().forEach(m -> this.add("subscriber-message", (String)m.getPayload())).build();
    }

    @Outgoing(value="subscriber-builder-message")
    public Publisher<Message<String>> sourceForSubscriberBuilderMessage() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="subscriber-builder-message")
    public SubscriberBuilder<Message<String>, Void> subscriberBuilderOfMessages() {
        SubscriberBean.increment("subscriber-builder-message");
        return ReactiveStreams.builder().forEach(m -> this.add("subscriber-builder-message", (String)m.getPayload()));
    }

    @Outgoing(value="subscriber-payload")
    public Publisher<Message<String>> sourceForSubscribePayload() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="subscriber-payload")
    public Subscriber<String> subscriberOfPayloads() {
        SubscriberBean.increment("subscriber-payload");
        return ReactiveStreams.builder().forEach(p -> this.add("subscriber-payload", (String)p)).build();
    }

    @Outgoing(value="subscriber-builder-payload")
    public Publisher<Message<String>> sourceForSubscriberBuilderPayload() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="subscriber-builder-payload")
    public SubscriberBuilder<String, Void> subscriberBuilderOfPayloads() {
        SubscriberBean.increment("subscriber-builder-payload");
        return ReactiveStreams.builder().forEach(p -> this.add("subscriber-builder-payload", (String)p));
    }

    @Outgoing(value="void-payload")
    public Publisher<Message<String>> sourceForVoidPayload() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="void-payload")
    public void consumePayload(String payload) {
        SubscriberBean.increment("void-payload");
        this.add("void-payload", payload);
    }

    @Outgoing(value="cs-void-message")
    public Publisher<Message<String>> sourceForCsVoidMessage() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="cs-void-message")
    public CompletionStage<Void> consumeMessageAndReturnCompletionStageOfVoid(Message<String> message) {
        SubscriberBean.increment("cs-void-message");
        return CompletableFuture.runAsync(() -> this.add("cs-void-message", (String)message.getPayload()), TckBase.EXECUTOR);
    }

    @Outgoing(value="cs-void-payload")
    public Publisher<Message<String>> sourceForCsVoidPayload() {
        return ReactiveStreams.fromIterable(EXPECTED).map(Message::of).buildRs();
    }

    @Incoming(value="cs-void-payload")
    public CompletionStage<Void> consumePayloadAndReturnCompletionStageOfVoid(String payload) {
        SubscriberBean.increment("cs-void-payload");
        return CompletableFuture.runAsync(() -> this.add("cs-void-payload", payload), TckBase.EXECUTOR);
    }

    private void add(String key, String value) {
        this.collector.computeIfAbsent(key, x -> new CopyOnWriteArrayList()).add(value);
    }

    void verify() {
        Awaitility.await().until(() -> this.collector.size() == 7);
        ((MapAssert)Assertions.assertThat(this.collector).hasSize(7)).allSatisfy((k, v) -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)v).containsExactlyElementsOf(EXPECTED);
        });
        Assertions.assertThat((AtomicInteger)counters.get("subscriber-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("subscriber-payload")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("subscriber-builder-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("subscriber-builder-payload")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("void-payload")).hasValue(EXPECTED.size());
        Assertions.assertThat((AtomicInteger)counters.get("cs-void-payload")).hasValue(EXPECTED.size());
        Assertions.assertThat((AtomicInteger)counters.get("cs-void-message")).hasValue(EXPECTED.size());
    }
}

