/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class AssignmentPartition
extends AbstractPartialPartition {
    private final @NonNull Node traceNode;

    public AssignmentPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest, @NonNull Edge realizedEdge) {
        super(partitioner, reachabilityForest, "\u00abedge-" + QVTscheduleUtil.getName((Nameable)realizedEdge) + "\u00bb");
        Node targetNode;
        this.traceNode = partitioner.getTraceNode();
        String name = this.region.getName();
        if ("mapHelper_Operation_qvtr".equals(name)) {
            this.getClass();
        }
        for (Node traceNode : partitioner.getTraceNodes()) {
            Node globalSuccessNode;
            this.addNode(traceNode, Role.PREDICATED);
            Node localSuccessNode = partitioner.basicGetLocalSuccessNode(traceNode);
            if (localSuccessNode != null) {
                this.addNode(localSuccessNode, Role.PREDICATED);
            }
            if ((globalSuccessNode = partitioner.basicGetGlobalSuccessNode(traceNode)) == null) continue;
            this.addNode(globalSuccessNode, Role.PREDICATED);
        }
        Node sourceNode = realizedEdge.getEdgeSource();
        if (!this.hasNode(sourceNode)) {
            Role sourceNodeRole = QVTscheduleUtil.getNodeRole((Node)sourceNode);
            if (sourceNodeRole == Role.REALIZED) {
                sourceNodeRole = QVTscheduleUtil.asPredicated((Role)sourceNodeRole);
            }
            this.addNode(sourceNode, sourceNodeRole);
        }
        if (!this.hasNode(targetNode = realizedEdge.getEdgeTarget())) {
            Role targetNodeRole = QVTscheduleUtil.getNodeRole((Node)targetNode);
            if (targetNodeRole == Role.REALIZED) {
                targetNodeRole = QVTscheduleUtil.asPredicated((Role)targetNodeRole);
            }
            this.addNode(targetNode, targetNodeRole);
        }
        this.resolvePrecedingNodes();
        Node qvtrThis = null;
        Node qvtrTransformation = null;
        for (Node node : this.getNodes()) {
            if ("qvtrThisVariable".equals(node.getName())) {
                qvtrThis = node;
                continue;
            }
            if (!"qvtrTransformation".equals(node.getName())) continue;
            qvtrTransformation = node;
        }
        if (qvtrThis != null != (qvtrTransformation != null)) {
            this.resolvePrecedingNodes();
        }
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        String namePrefix = "\u00abedge" + partitionNumber + "\u00bb";
        String symbolSuffix = "_p" + partitionNumber;
        return this.createMicroMappingRegion(namePrefix, symbolSuffix);
    }

    @Override
    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this){

            public @Nullable Element visitSuccessNode(@NonNull SuccessNode node) {
                BooleanLiteralNode partialNode = this.regionHelper.createBooleanLiteralNode(true);
                this.addNode((Node)node, (Node)partialNode);
                return partialNode;
            }
        };
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            AbstractPartialPartition realizingPartition = this.partitioner.getRealizingPartition(edge);
            if (realizingPartition instanceof AssignmentPartition && !this.transformationAnalysis.isCorollary(QVTscheduleUtil.getTargetNode((Edge)edge))) {
                return null;
            }
            if (realizingPartition != null) {
                edgeRole = Role.PREDICATED;
            }
        }
        return edgeRole;
    }
}

