/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewQVTProjectCreationPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.QVTProjectFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class NewQVTProjectContentPage
extends WizardPage {
    protected static final int PROPERTIES_GROUP = 1;
    protected static final int CLASS_GROUP = 2;
    protected int myChangedGroups = 0;
    private NewQVTProjectCreationPage myMainPage;
    private QVTProjectFieldData myData;
    private Text myIdText;
    private Text myVersionText;
    private Text myNameText;
    private Text myProviderText;
    private Label myLibraryLabel;
    private Text myLibraryText;
    private Button myGenerateClass;
    private Label myClassLabel;
    private Text myClassText;
    private boolean myInitialized;

    public NewQVTProjectContentPage(String pageName, NewQVTProjectCreationPage page, QVTProjectFieldData data) {
        super(pageName);
        this.myMainPage = page;
        this.myData = data;
        this.setTitle(Messages.ContentPage_title);
        this.setDescription(Messages.ContentPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createPluginClassGroup(container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.m2m.qvt.oml.transformation_project");
    }

    protected Text createText(Composite parent, ModifyListener listener) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        return text;
    }

    private void createPluginPropertiesGroup(Composite container) {
        ModifyListener propertiesListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewQVTProjectContentPage.this.myInitialized) {
                    NewQVTProjectContentPage.this.myChangedGroups |= 1;
                }
                NewQVTProjectContentPage.this.validatePage();
            }
        };
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(Messages.ContentPage_pGroup);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(Messages.ContentPage_pid);
        this.myIdText = this.createText((Composite)propertiesGroup, propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(Messages.ContentPage_pversion);
        this.myVersionText = this.createText((Composite)propertiesGroup, propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(Messages.ContentPage_pname);
        this.myNameText = this.createText((Composite)propertiesGroup, propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(Messages.ContentPage_pprovider);
        this.myProviderText = this.createText((Composite)propertiesGroup, propertiesListener);
        this.myLibraryLabel = new Label((Composite)propertiesGroup, 0);
        this.myLibraryLabel.setText(Messages.ProjectStructurePage_library);
        this.myLibraryText = this.createText((Composite)propertiesGroup, propertiesListener);
    }

    private void createPluginClassGroup(Composite container) {
        ModifyListener classListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewQVTProjectContentPage.this.myInitialized) {
                    NewQVTProjectContentPage.this.myChangedGroups |= 2;
                }
                NewQVTProjectContentPage.this.validatePage();
            }
        };
        Group classGroup = new Group(container, 0);
        classGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        classGroup.setLayoutData((Object)gd);
        classGroup.setText(Messages.ContentPage_pClassGroup);
        this.myGenerateClass = new Button((Composite)classGroup, 32);
        this.myGenerateClass.setText(Messages.ContentPage_generate);
        this.myGenerateClass.setSelection(this.myData.doGenerateClass());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.myGenerateClass.setLayoutData((Object)gd);
        this.myGenerateClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewQVTProjectContentPage.this.myClassLabel.setEnabled(NewQVTProjectContentPage.this.myGenerateClass.getSelection());
                NewQVTProjectContentPage.this.myClassText.setEnabled(NewQVTProjectContentPage.this.myGenerateClass.getSelection());
                NewQVTProjectContentPage.this.updateData();
                NewQVTProjectContentPage.this.validatePage();
            }
        });
        this.myClassLabel = new Label((Composite)classGroup, 0);
        this.myClassLabel.setText(Messages.ContentPage_classname);
        this.myClassLabel.setEnabled(this.myGenerateClass.getSelection());
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.myClassLabel.setLayoutData((Object)gd);
        this.myClassText = this.createText((Composite)classGroup, classListener);
        this.myClassText.setEnabled(this.myGenerateClass.getSelection());
    }

    protected String computeId() {
        return this.myMainPage.getProjectName().replaceAll("[^a-zA-Z0-9\\._]", "_");
    }

    private void presetLibraryField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.myLibraryText.setText(String.valueOf(token) + ".jar");
        }
    }

    private void presetNameField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.myNameText.setText(String.valueOf(Character.toUpperCase(token.charAt(0))) + (token.length() > 1 ? token.substring(1) : "") + " " + this.getNameFieldQualifier());
        }
    }

    private void presetClassField(Text text, String id, String suffix) {
        IStatus status;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JavaConventions.validatePackageName((String)buffer.toString());
                if (status.getSeverity() == 4) {
                    buffer.append(suffix.toLowerCase());
                }
                buffer.append(ch);
            }
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            status = JavaConventions.validatePackageName((String)buffer.toString());
            if (status.getSeverity() == 4) {
                buffer.append(suffix.toLowerCase());
            }
            buffer.append("." + Character.toUpperCase(token.charAt(0)) + token.substring(1) + suffix);
        }
        text.setText(buffer.toString());
    }

    private void presetProviderField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        int count = tok.countTokens();
        if (count > 2 && tok.nextToken().equals("com")) {
            this.myProviderText.setText(tok.nextToken().toUpperCase());
        }
    }

    private String getNameFieldQualifier() {
        return Messages.ContentPage_plugin;
    }

    public IWizardPage getNextPage() {
        this.updateData();
        return super.getNextPage();
    }

    public void updateData() {
        this.myData.setId(this.myIdText.getText().trim());
        this.myData.setVersion(this.myVersionText.getText().trim());
        this.myData.setName(this.myNameText.getText().trim());
        this.myData.setProvider(this.myProviderText.getText().trim());
        String library = this.myLibraryText.getText().trim();
        if (library.length() > 0) {
            if (!(library.endsWith(".jar") || library.endsWith("/") || library.equals("."))) {
                library = String.valueOf(library) + "/";
            }
            this.myData.setLibraryName(library);
        } else {
            this.myData.setLibraryName(null);
        }
        this.myData.setClassname(this.myClassText.getText().trim());
        this.myData.setDoGenerateClass(this.myGenerateClass.isEnabled() && this.myGenerateClass.getSelection());
    }

    protected void validatePage() {
        this.setMessage(null);
        String errorMessage = this.validateProperties();
        if (errorMessage == null && this.myLibraryText.getText().trim().length() == 0) {
            errorMessage = Messages.ContentPage_noLibrary;
        }
        if (errorMessage == null && this.myGenerateClass.isEnabled() && this.myGenerateClass.getSelection()) {
            IStatus status = JavaConventions.validateJavaTypeName((String)this.myClassText.getText().trim());
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    protected String validateProperties() {
        String errorMessage = this.validateId();
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.myVersionText.getText().trim().length() == 0) {
            errorMessage = Messages.ContentPage_noversion;
        } else if (!this.isVersionValid(this.myVersionText.getText().trim())) {
            errorMessage = Messages.ContentPage_badversion;
        } else if (this.myNameText.getText().trim().length() == 0) {
            errorMessage = Messages.ContentPage_noname;
        }
        if (errorMessage != null) {
            return errorMessage;
        }
        return errorMessage;
    }

    private String validateId() {
        String id = this.myIdText.getText().trim();
        if (id.length() == 0) {
            return Messages.ContentPage_noid;
        }
        if (!NewQVTProjectContentPage.isValidPluginId(id)) {
            return Messages.ContentPage_invalidId;
        }
        return null;
    }

    protected boolean isVersionValid(String version) {
        try {
            new Version(version);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean isGenerateClassAllowed;
            int oldChanged;
            this.myMainPage.updateData();
            String id = this.computeId();
            if ((this.myChangedGroups & 1) == 0) {
                oldChanged = this.myChangedGroups;
                this.myIdText.setText(id);
                this.myVersionText.setText("1.0.0");
                this.presetNameField(id);
                this.presetProviderField(id);
                this.presetLibraryField(id);
                this.myChangedGroups = oldChanged;
            }
            if ((this.myChangedGroups & 2) == 0) {
                oldChanged = this.myChangedGroups;
                this.presetClassField(this.myClassText, this.computeId(), "Activator");
                this.myChangedGroups = oldChanged;
            }
            if (this.myInitialized) {
                this.validatePage();
            } else {
                this.myInitialized = true;
            }
            boolean bl = isGenerateClassAllowed = !this.myData.isSimple();
            if (!isGenerateClassAllowed) {
                this.myGenerateClass.setSelection(false);
            }
            this.myGenerateClass.setEnabled(isGenerateClassAllowed);
            this.myClassText.setEnabled(isGenerateClassAllowed);
            this.myClassLabel.setEnabled(isGenerateClassAllowed);
            this.myIdText.setFocus();
        }
    }

    private static boolean isValidPluginId(String name) {
        if (name.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c || c == '_' || i != 0 && i != name.length() - 1 && c == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

