/*
 * Decompiled with CFR 0.152.
 */
package jpoxtutorial;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.JpoxHelper;
import org.eclipse.example.library.Book;
import org.eclipse.example.library.BookCategory;
import org.eclipse.example.library.Library;
import org.eclipse.example.library.LibraryFactory;
import org.eclipse.example.library.LibraryPackage;
import org.eclipse.example.library.Writer;
import org.eclipse.example.library.impl.BookImpl;
import org.eclipse.example.library.impl.LibraryImpl;
import org.eclipse.example.library.impl.WriterImpl;

public class Tutorial1 {
    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("javax.jdo.option.ConnectionDriverName", "com.mysql.jdbc.Driver");
        properties.setProperty("javax.jdo.option.ConnectionURL", "jdbc:mysql://127.0.0.1:3306/mylibrary");
        properties.setProperty("javax.jdo.option.ConnectionUserName", "root");
        properties.setProperty("javax.jdo.option.ConnectionPassword", "root");
        String pmfName = "MyPMF";
        JpoxDataStore jpoxDataStore = JpoxHelper.INSTANCE.createRegisterDataStore(pmfName);
        jpoxDataStore.setProperties(properties);
        jpoxDataStore.setEPackages(new EPackage[]{LibraryPackage.eINSTANCE});
        jpoxDataStore.initialize();
        PersistenceManager pm = jpoxDataStore.getPMF().getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        tx.begin();
        Library lib = LibraryFactory.eINSTANCE.createLibrary();
        lib.setName("My Library");
        pm.makePersistent((Object)lib);
        Writer writer = LibraryFactory.eINSTANCE.createWriter();
        writer.setName("JRR Tolkien");
        Book book = LibraryFactory.eINSTANCE.createBook();
        book.setAuthor(writer);
        book.setPages(305);
        book.setTitle("The Hobbit");
        book.setCategory(BookCategory.SCIENCE_FICTION);
        lib.getWriters().add((Object)writer);
        lib.getBooks().add((Object)book);
        tx.commit();
        pm.close();
        pm = jpoxDataStore.getPMF().getPersistenceManager();
        tx = pm.currentTransaction();
        tx.begin();
        Extent e = pm.getExtent(LibraryImpl.class, true);
        Query q = pm.newQuery(e);
        Collection c = (Collection)q.execute();
        lib = (Library)c.iterator().next();
        writer = (Writer)lib.getWriters().get(0);
        System.out.println(writer.getName());
        book = (Book)lib.getBooks().get(0);
        System.out.println(book.getTitle());
        System.out.println(book.eContainer() == lib);
        System.out.println(writer.getBooks().get(0) == book);
        Writer george = LibraryFactory.eINSTANCE.createWriter();
        george.setName("G. Orwell");
        Book georgesBook = LibraryFactory.eINSTANCE.createBook();
        georgesBook.setPages(250);
        georgesBook.setTitle("1984");
        georgesBook.setCategory(BookCategory.SCIENCE_FICTION);
        georgesBook.setAuthor(george);
        lib.getBooks().add((Object)georgesBook);
        lib.getWriters().add((Object)george);
        tx.commit();
        pm.close();
        pm = jpoxDataStore.getPMF().getPersistenceManager();
        tx = pm.currentTransaction();
        tx.begin();
        Query qry = pm.newQuery("SELECT FROM " + BookImpl.class.getName());
        Collection coll = (Collection)qry.execute();
        System.out.println(((Book)coll.iterator().next()).getTitle());
        System.out.println(((Book)coll.iterator().next()).getTitle());
        qry = pm.newQuery("SELECT FROM " + BookImpl.class.getName() + " WHERE " + " title==\"1984\" && author == writ && writ.name == \"G. Orwell\" " + "VARIABLES " + WriterImpl.class.getName() + " writ");
        coll = (Collection)qry.execute();
        System.out.println(coll.size());
        Book bk = (Book)coll.iterator().next();
        System.out.println(bk.getTitle());
        System.out.println(bk.getAuthor().getName());
        qry = pm.newQuery("SELECT FROM " + LibraryImpl.class.getName() + " WHERE name.endsWith(\"Library\")");
        coll = (Collection)qry.execute();
        lib = (Library)coll.iterator().next();
        qry = pm.newQuery("SELECT FROM " + BookImpl.class.getName() + " WHERE " + " title==\"1984\" && author == writ && writ.name == \"G. Orwell\" " + "VARIABLES " + WriterImpl.class.getName() + " writ");
        System.err.println(((Collection)qry.execute()).size());
        qry = pm.newQuery("SELECT FROM " + BookImpl.class.getName());
        System.err.println(((Collection)qry.execute()).size());
        qry = pm.newQuery("SELECT FROM " + LibraryImpl.class.getName() + " WHERE name.endsWith(\"Library\")");
        System.err.println(((Collection)qry.execute()).size());
        tx.commit();
        pm.close();
        try {
            String uriStr = "jpox://?dsname=MyPMF";
            URI uri = URI.createURI((String)uriStr);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource res = resourceSet.createResource(uri);
            res.load(Collections.EMPTY_MAP);
            for (Library libTest : res.getContents()) {
                System.out.println(libTest.getName());
            }
            Library libNew = LibraryFactory.eINSTANCE.createLibrary();
            libNew.setName("My Second Library");
            Writer writerNew = LibraryFactory.eINSTANCE.createWriter();
            writerNew.setName("I. Asimov");
            Book bookNew = LibraryFactory.eINSTANCE.createBook();
            bookNew.setAuthor(writerNew);
            bookNew.setPages(305);
            bookNew.setTitle("Foundation and Empire");
            bookNew.setCategory(BookCategory.SCIENCE_FICTION);
            libNew.getWriters().add((Object)writerNew);
            libNew.getBooks().add((Object)bookNew);
            res.getContents().add((Object)libNew);
            res.save(Collections.EMPTY_MAP);
        }
        catch (IOException i) {
            throw new RuntimeException("IOException " + i.getMessage(), i);
        }
        jpoxDataStore.close();
    }
}

