/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class ReturnTypeRule
implements ISequenceRule {
    private final IToken token;

    public ReturnTypeRule(IToken token) {
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public int read(ICharacterScanner scanner) {
        int column = scanner.getColumn();
        if (!this.validateLocation(scanner)) {
            return 0;
        }
        assert (scanner.getColumn() == column);
        int shift = 0;
        int c = scanner.read();
        ++shift;
        while (c != -1 && (c == 58 || Character.isJavaIdentifierPart(c))) {
            c = scanner.read();
            ++shift;
        }
        scanner.unread();
        return --shift;
    }

    private boolean validateLocation(ICharacterScanner scanner) {
        int c;
        boolean valid = true;
        int shift = 0;
        do {
            c = this.unreadChar(scanner);
            --shift;
        } while (c != -1 && Character.isWhitespace(c));
        int i = ":".length() - 1;
        while (valid && i >= 0) {
            if (c == -1 || c != ":".charAt(i)) {
                valid = false;
            } else {
                c = this.unreadChar(scanner);
                --shift;
            }
            --i;
        }
        do {
            c = this.unreadChar(scanner);
            --shift;
        } while (c != -1 && Character.isWhitespace(c));
        if (c != 41) {
            valid = false;
        }
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        return valid;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

