/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser.jasper;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.internal.core.parser.jasper.JETCoreElement;
import org.eclipse.jet.internal.core.parser.jasper.JETException;
import org.eclipse.jet.internal.core.parser.jasper.JETMark;
import org.eclipse.jet.internal.core.parser.jasper.JETParseEventListener;
import org.eclipse.jet.internal.core.parser.jasper.JETParseEventListener2;
import org.eclipse.jet.internal.core.parser.jasper.JETReader;
import org.eclipse.jet.internal.core.parser.jasper.MessagesUtil;

public class JETParser
implements JETReader.IStackPopNotifier {
    protected JETReader reader;
    protected JETParseEventListener listener;
    protected CharArrayWriter writer;
    protected List coreElements = new ArrayList();
    protected String openDirective = "<%@";
    protected String closeDirective = "%>";
    protected String openScriptlet = "<%";
    protected String closeScriptlet = "%>";
    protected String openExpr = "<%=";
    protected String closeExpr = "%>";
    protected String quotedStartTag = "<\\%";
    protected String quotedEndTag = "%\\>";
    protected String startTag = "<%";
    protected String endTag = "%>";

    public JETParser(JETReader reader, JETParseEventListener parseEventListener, JETCoreElement[] coreElements) {
        this.reader = reader;
        reader.setStackPopNotifier(this);
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            public void execute() throws JETException {
                JETParser.this.flushCharData();
            }
        });
        this.writer = new CharArrayWriter();
        int i = 0;
        while (i < coreElements.length) {
            this.coreElements.add(coreElements[i]);
            ++i;
        }
    }

    public JETReader getReader() {
        return this.reader;
    }

    public void setStartTag(String tag) {
        this.openScriptlet = tag;
        this.openExpr = String.valueOf(tag) + "=";
        this.openDirective = String.valueOf(tag) + "@";
        this.quotedStartTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.startTag = tag;
        this.reader.setStartTag(tag);
    }

    public void setEndTag(String tag) {
        this.closeScriptlet = tag;
        this.closeExpr = tag;
        this.closeDirective = tag;
        this.quotedEndTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.endTag = tag;
        this.reader.setEndTag(tag);
    }

    public String getOpenScriptlet() {
        return this.openScriptlet;
    }

    public String getCloseScriptlet() {
        return this.closeScriptlet;
    }

    public String getOpenExpr() {
        return this.openExpr;
    }

    public String getCloseExpr() {
        return this.closeExpr;
    }

    public String getOpenDirective() {
        return this.openDirective;
    }

    public String getCloseDirective() {
        return this.closeDirective;
    }

    public String getQuotedStartTag() {
        return this.quotedStartTag;
    }

    public String getQuotedEndTag() {
        return this.quotedEndTag;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public String getEndTag() {
        return this.endTag;
    }

    protected void flushCharData() throws JETException {
        char[] array = this.writer.toCharArray();
        if (array.length != 0) {
            this.writer = new CharArrayWriter();
            this.listener.handleCharData(array);
        }
    }

    public void parse() throws JETException {
        this.parse(null);
    }

    public void parse(String until) throws JETException {
        this.parse(until, null);
    }

    public void parse(String until, Class[] accept) throws JETException {
        while (this.reader.hasMoreInput()) {
            JETCoreElement c;
            if (until != null && this.reader.matches(until)) {
                return;
            }
            Iterator e = this.coreElements.iterator();
            if (accept != null) {
                ArrayList<JETCoreElement> v = new ArrayList<JETCoreElement>();
                while (e.hasNext()) {
                    c = (JETCoreElement)e.next();
                    int i = 0;
                    while (i < accept.length) {
                        if (c.getClass().equals(accept[i])) {
                            v.add(c);
                        }
                        ++i;
                    }
                }
                e = v.iterator();
            }
            boolean accepted = false;
            while (e.hasNext()) {
                c = (JETCoreElement)e.next();
                this.reader.mark();
                if (!c.accept(this.listener, this.reader, this)) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            String s = this.reader.nextContent();
            this.writer.write(s, 0, s.length());
        }
        this.flushCharData();
    }

    public void stackPopped() {
        block2: {
            try {
                this.listener.endPageProcessing();
            }
            catch (JETException e) {
                if (!(this.listener instanceof JETParseEventListener2)) break block2;
                ((JETParseEventListener2)this.listener).recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), new Object[0], -1, -1, -1, -1);
            }
        }
    }

    public static interface Action {
        public void execute() throws JETException;
    }

    public static class DelegatingListener
    implements JETParseEventListener2 {
        protected JETParseEventListener delegate;
        protected Action action;

        public DelegatingListener(JETParseEventListener delegate, Action action) {
            this.delegate = delegate;
            this.action = action;
        }

        public void doAction() throws JETException {
            this.action.execute();
        }

        public void beginPageProcessing() throws JETException {
            this.delegate.beginPageProcessing();
        }

        public void endPageProcessing() throws JETException {
            this.action.execute();
            this.delegate.endPageProcessing();
        }

        public void handleDirective(String directive, JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleDirective(directive, start, stop, attrs);
        }

        public void handleScriptlet(JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleScriptlet(start, stop, attrs);
        }

        public void handleExpression(JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleExpression(start, stop, attrs);
        }

        public void handleCharData(char[] chars) throws JETException {
            this.delegate.handleCharData(chars);
        }

        public void handleComment(JETMark start, JETMark stop) throws JETException {
            this.doAction();
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).handleComment(start, stop);
        }

        public void handleDeclaration(JETMark start, JETMark stop) throws JETException {
            this.doAction();
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).handleDeclaration(start, stop);
        }

        public void handleXMLEndTag(String tagName, JETMark start, JETMark stop) throws JETException {
            this.doAction();
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).handleXMLEndTag(tagName, start, stop);
        }

        public void handleXMLEmptyTag(String tagName, JETMark start, JETMark stop, Map attributeMap) throws JETException {
            this.doAction();
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).handleXMLEmptyTag(tagName, start, stop, attributeMap);
        }

        public void handleXMLStartTag(String tagName, JETMark start, JETMark stop, Map attributeMap) throws JETException {
            this.doAction();
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).handleXMLStartTag(tagName, start, stop, attributeMap);
        }

        public boolean isKnownTag(String tagName) {
            if (this.delegate instanceof JETParseEventListener2) {
                return ((JETParseEventListener2)this.delegate).isKnownTag(tagName);
            }
            throw new IllegalStateException();
        }

        public void recordProblem(ProblemSeverity severity, int problemId, String message, Object[] msgArgs, int start, int end, int line, int colOffset) {
            if (!(this.delegate instanceof JETParseEventListener2)) {
                throw new IllegalStateException();
            }
            ((JETParseEventListener2)this.delegate).recordProblem(severity, problemId, message, msgArgs, start, end, line, colOffset);
        }

        public boolean isKnownInvalidTagName(String tagName) {
            if (this.delegate instanceof JETParseEventListener2) {
                return ((JETParseEventListener2)this.delegate).isKnownInvalidTagName(tagName);
            }
            throw new IllegalStateException();
        }
    }

    public static class Directive
    implements JETCoreElement {
        protected Collection directives = new ArrayList();

        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            if (reader.matches(parser.getOpenDirective())) {
                JETMark start = reader.mark();
                reader.advance(parser.getOpenDirective().length());
                reader.skipSpaces();
                String match = null;
                Iterator i = this.directives.iterator();
                while (i.hasNext()) {
                    String directive = (String)i.next();
                    if (!reader.matches(directive)) continue;
                    match = directive;
                    break;
                }
                if (match == null) {
                    throw new JETException(MessagesUtil.getString("jet.error.bad.directive", new Object[]{start.format("jet.mark.file.line.column")}));
                }
                reader.advance(match.length());
                HashMap attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(parser.getCloseDirective())) {
                    throw new JETException(MessagesUtil.getUnterminatedMessage(reader, parser.getOpenDirective(), parser.getCloseDirective()));
                }
                reader.advance(parser.getCloseDirective().length());
                JETMark stop = reader.mark();
                listener.handleDirective(match, start, stop, attrs);
                return true;
            }
            return false;
        }

        public Collection getDirectives() {
            return this.directives;
        }
    }

    public static class Expression
    implements JETCoreElement {
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            Map attrs = null;
            if (!reader.matches(parser.getOpenExpr())) {
                return false;
            }
            String open = parser.getOpenExpr();
            String close = parser.getCloseExpr();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JETException(MessagesUtil.getUnterminatedMessage(reader, open, close));
            }
            listener.handleExpression(start, stop, attrs);
            return true;
        }
    }

    public static class QuoteEscape
    implements JETCoreElement {
        protected static final String APOS = "&apos;";
        protected static final String QUOTE = "&quote;";

        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            block6: {
                block5: {
                    try {
                        if (!reader.matches(parser.getQuotedEndTag())) break block5;
                        reader.advance(parser.getQuotedEndTag().length());
                        parser.writer.write(parser.getEndTag());
                        parser.flushCharData();
                        return true;
                    }
                    catch (IOException exception) {
                        throw new JETException(exception);
                    }
                }
                if (!reader.matches(APOS)) break block6;
                reader.advance(APOS.length());
                parser.writer.write("'");
                parser.flushCharData();
                return true;
            }
            if (reader.matches(QUOTE)) {
                reader.advance(QUOTE.length());
                parser.writer.write("\"");
                parser.flushCharData();
                return true;
            }
            return false;
        }
    }

    public static class Scriptlet
    implements JETCoreElement {
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            Map attrs = null;
            if (!reader.matches(parser.getOpenScriptlet())) {
                return false;
            }
            String open = parser.getOpenScriptlet();
            String close = parser.getCloseScriptlet();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JETException(MessagesUtil.getUnterminatedMessage(reader, close, open));
            }
            listener.handleScriptlet(start, stop, attrs);
            return true;
        }
    }
}

